/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache2;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.RemoteMarker;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.Argument;
import com.elixirtech.data2.datasource.cache2.ICache;
import com.elixirtech.data2.datasource.cache2.ICacheManager;
import com.elixirtech.data2.datasource.cache2.MemoryCache;
import com.elixirtech.repository.RMLFileObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class CacheDataSource
extends FileBasedDataSource {
    public static final String TYPE = "Cache2";
    public static final String CACHE_MEMORY = "Memory";
    public static final String CACHE_DB = "DB";
    protected List<Argument> m_Arguments = new ArrayList<Argument>();
    protected String m_DataSourceName;
    protected String m_Name;
    protected String m_Description;
    protected IDataSource m_DataSource;
    protected long m_ExpiryInterval;
    protected String m_CacheType = "Memory";
    protected List<Parameter> m_Parameters;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CacheDataSource.class);

    public CacheDataSource() {
    }

    public CacheDataSource(String string, String string2) {
        this.m_Name = string;
        this.m_DataSourceName = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setExpiryInterval(long l) {
        this.m_ExpiryInterval = l;
    }

    public long getExpiryInterval() {
        return this.m_ExpiryInterval;
    }

    public void setCacheType(String string) {
        this.m_CacheType = string;
    }

    public String getCacheType() {
        return this.m_CacheType;
    }

    public void setDataSourceName(String string) {
        this.m_DataSourceName = string;
    }

    public String getDataSourceName() {
        return this.m_DataSourceName;
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.m_Parameters == null) {
            this.buildParameters();
        }
        return Collections.unmodifiableList(this.m_Parameters);
    }

    private void buildParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        for (Argument argument : this.m_Arguments) {
            argumentMap.extractParameters(argument.getValue());
        }
        this.m_Parameters = argumentMap.getParameters();
    }

    public void removeAllArguments() {
        this.m_Arguments.clear();
        this.m_Parameters = null;
        this.setDirty(true);
    }

    public void addArgument(String string, String string2) {
        this.m_Arguments.add(new Argument(string, string2));
        this.m_Parameters = null;
        this.setDirty(true);
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.m_Arguments);
    }

    @Override
    public DataSchema getSchema() {
        try {
            if (this.m_DataSource == null) {
                this.resolve();
            }
            return this.m_DataSource.getSchema();
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't locate datasource schema for " + this.m_DataSourceName + " : " + String.valueOf(exception)));
            return new DataSchema(true, new String[0], new DataType[0]);
        }
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        String string;
        DataSchema dataSchema;
        ICache iCache;
        assert (Elixir.get(RemoteMarker.class) == null);
        ICacheManager iCacheManager = (ICacheManager)Elixir.get(ICacheManager.class);
        if (iCacheManager == null) {
            throw new RuntimeException("ICacheManager unavailable in this context");
        }
        ICachedFile iCachedFile = this.getAdapter(ICachedFile.class);
        RMLFileObject rMLFileObject = iCachedFile.getFileObject();
        String string2 = rMLFileObject.getPathString();
        if (this.m_DataSource == null) {
            this.resolve();
        }
        if ((iCache = iCacheManager.getCache(string2, dataSchema = this.m_DataSource.getSchema(), string = this.defineMemento(pushContext))) != null) {
            iCache.pushTo(pushContext, dataListener);
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Argument object2 : this.m_Arguments) {
                hashMap.put(object2.getName(), pushContext.substitute(object2.getValue()));
            }
            PushContext pushContext2 = pushContext.subContext(hashMap);
            DataTable dataTable = DataTable.build(pushContext2, this.m_DataSource);
            long l = this.m_ExpiryInterval == 0L ? 0L : System.currentTimeMillis() + this.m_ExpiryInterval * 1000L;
            MemoryCache memoryCache = null;
            if (CACHE_MEMORY.equals(this.m_CacheType)) {
                memoryCache = new MemoryCache(string2, l, dataTable, string);
            }
            if (memoryCache != null) {
                iCacheManager.addCache(memoryCache);
                memoryCache.pushTo(pushContext2, dataListener);
            } else {
                m_Log.info((Object)"No cache type recognised - bypassing cache");
                this.m_DataSource.pushTo(pushContext, dataListener);
            }
        }
    }

    protected IDataSource getDataSource() {
        if (this.m_DataSource == null) {
            this.resolve();
        }
        return this.m_DataSource;
    }

    protected void setDataSource(IDataSource iDataSource) {
        this.m_DataSource = iDataSource;
    }

    protected void resolve() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        this.m_DataSource = dataSourceManager.getDataSource(dataSourceManager, this.m_DataSourceName);
    }

    protected String defineMemento(PushContext pushContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter object : this.getParameters()) {
            arrayList.add(object.getName());
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append('(');
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(pushContext.getParameter(string));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

