/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache2;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.Argument;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.cache2.CacheDataSource;
import com.elixirtech.jdom.Element;

public class CacheDefinition
extends DataSourceDefinition {
    public static final String REF_NAME = "ref-name";
    public static final String ARGUMENT = "argument";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String EXPIRY_INTERVAL = "expiry-interval";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("description");
        String string3 = element.getAttributeValue(REF_NAME);
        String string4 = element.getAttributeValue(EXPIRY_INTERVAL);
        CacheDataSource cacheDataSource = new CacheDataSource(string, string3);
        cacheDataSource.setDescription(string2);
        long l = 0L;
        try {
            if (StringUtil.notEmpty(string4)) {
                l = Long.parseLong(string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        cacheDataSource.setExpiryInterval(l);
        for (Element element2 : element.getChildren(ARGUMENT, NS_DATASOURCE)) {
            String string5 = element2.getAttributeValue(KEY);
            String string6 = element2.getAttributeValue(VALUE);
            if (string5 == null) continue;
            cacheDataSource.addArgument(string5, string6);
        }
        cacheDataSource.setSecurity(this.loadSecurity(element));
        return cacheDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof CacheDataSource)) {
            throw new IllegalArgumentException("Not a RefDataSource");
        }
        CacheDataSource cacheDataSource = (CacheDataSource)iDataSource;
        Element element = this.defineDataSource(cacheDataSource);
        String string = cacheDataSource.getDataSourceName();
        element.setAttribute(EXPIRY_INTERVAL, String.valueOf(cacheDataSource.getExpiryInterval()));
        if (string != null) {
            element.setAttribute(REF_NAME, string);
        }
        for (Argument argument : cacheDataSource.getArguments()) {
            Element element2 = new Element(ARGUMENT, NS_DATASOURCE);
            element2.setAttribute(KEY, argument.getName());
            element2.setAttribute(VALUE, argument.getValue());
            element.addContent(element2);
        }
        this.saveSecurity(cacheDataSource.getSecurity(), element);
        return element;
    }
}

