/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.codec;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.jdom.Element;

public class ConnectionPoolCodec
implements DataStoreCodec {
    public static final String FILE_URL = "file-url";

    @Override
    public DataStore buildDataStore(Element element) {
        DataStore dataStore = new DataStore("Connection Pool");
        Element element2 = element.getChild("connection-pool", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            dataStore.setProperty(FILE_URL, element2.getAttributeValue(FILE_URL));
            dataStore.setProperty("JDBC_Append", element2.getAttributeValue("append"));
            dataStore.setProperty("JDBC_Dialect", element2.getAttributeValue("dialect"));
            dataStore.setProperty("JDBC_Exists", element2.getAttributeValue("exists"));
            dataStore.setProperty("JDBC_TableName", element2.getAttributeValue("table"));
            dataStore.setProperty("JDBC_AutoCommit", this.notNull(element2.getAttributeValue("auto-commit")));
            dataStore.setProperty("JDBC_UpdateInsert", this.notNull(element2.getAttributeValue("update-insert")));
            dataStore.setProperty("JDBC_ReturnKeys", this.notNull(element2.getAttributeValue("return-keys")));
            dataStore.setProperty("JDBC_ErrorStoreURL", this.notNull(element2.getAttributeValue("error-store-url")));
        }
        return dataStore;
    }

    @Override
    public Element buildElement(Node node) {
        Element element = new Element("connection-pool", Data2Constants.NS_DATASOURCE);
        element.setAttribute(FILE_URL, this.notNull(node.getUserProperty(FILE_URL)));
        element.setAttribute("dialect", this.notNull(node.getUserProperty("JDBC_Dialect")));
        element.setAttribute("append", this.notNull(node.getUserProperty("JDBC_Append")));
        element.setAttribute("exists", this.notNull(node.getUserProperty("JDBC_Exists")));
        element.setAttribute("auto-commit", this.notNull(node.getUserProperty("JDBC_AutoCommit")));
        element.setAttribute("update-insert", this.notNull(node.getUserProperty("JDBC_UpdateInsert")));
        element.setAttribute("return-keys", this.notNull(node.getUserProperty("JDBC_ReturnKeys")));
        element.setAttribute("error-store-url", this.notNull(node.getUserProperty("JDBC_ErrorStoreURL")));
        return element;
    }

    private String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

