/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.INestedDiagramHolder;
import com.elixirtech.canvas.xml.XmlUtil;
import com.elixirtech.data.transform.TransformConfigurator;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.ensemble.canvas.CompositeDiagram;
import com.elixirtech.ensemble.canvas.CubeGO;
import com.elixirtech.ensemble.ds.DSBuilder;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.io.IOException;
import java.util.HashMap;

public class CompositeDefinition
extends DataSourceDefinition {
    public static final String COMPOSITE = "composite";
    public static final String VERSION = "version";
    public static final String RESULT = "result";
    public static final String GRAPH = "graph";
    public static final String SCRIPT = "script";
    public static final String CURRENT_VERSION = "2";
    public static TransformConfigurator tcInit = new TransformConfigurator();

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        Element element2;
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("description");
        String string3 = element.getAttributeValue(VERSION);
        DataSchema dataSchema = null;
        Element element3 = element.getChild("schema", NS_DATASOURCE);
        if (element3 != null) {
            CompositeDefinition.loadSchema(element3);
        }
        CompositeDataSource compositeDataSource = new CompositeDataSource();
        compositeDataSource.setName(string);
        compositeDataSource.setDescription(string2);
        compositeDataSource.setSchema(dataSchema);
        compositeDataSource.setSecurity(this.loadSecurity(element));
        Element element4 = element.getChild(COMPOSITE, NS_DATASOURCE);
        if (element4 != null && (element2 = element4.getChild(SCRIPT, NS_DATASOURCE)) != null) {
            compositeDataSource.setJavaScript(element2.getText());
        }
        if ((element2 = element.getChild(GRAPH)) != null) {
            this.processGraph(compositeDataSource, element2);
            this.fixVersion(compositeDataSource, string3);
        }
        return compositeDataSource;
    }

    private void processGraph(CompositeDataSource compositeDataSource, Element element) throws DataException {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.elixirtech.canvas.corego.Diagram", "com.elixirtech.ensemble.canvas.CompositeDiagram");
            CompositeDiagram compositeDiagram = (CompositeDiagram)XmlUtil.loadDiagramFromJDOM(element, hashMap);
            compositeDiagram.setDataSource(compositeDataSource);
            compositeDataSource.setDiagram(compositeDiagram);
            new DSBuilder(compositeDataSource);
        }
        catch (IOException iOException) {
            throw new DataException("Can't load graph data : " + String.valueOf(iOException), iOException);
        }
    }

    private void fixVersion(CompositeDataSource compositeDataSource, String string) {
        if (string == null) {
            CompositeDiagram compositeDiagram = compositeDataSource.getDiagram();
            for (GO gO : compositeDiagram.getChildGOs()) {
                this.migrate12(gO);
            }
        }
    }

    private void migrate12(Diagram diagram) {
        for (GO gO : diagram.getChildGOs()) {
            this.migrate12(gO);
        }
    }

    private void migrate12(GO gO) {
        if (gO instanceof INestedDiagramHolder) {
            this.migrate12(((INestedDiagramHolder)((Object)gO)).getNestedDiagram());
        } else if (gO instanceof CubeGO) {
            String[] stringArray;
            Object object;
            CubeGO cubeGO = (CubeGO)gO;
            cubeGO.setKeepRowTotals(false);
            cubeGO.setKeepColumnTotals(true);
            String string = gO.getUserProperty("Cube_Row");
            if (StringUtil.notEmpty(string)) {
                object = string.split(",");
                stringArray = new String[((String[])object).length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "No";
                }
                cubeGO.setUserProperty("Cube_Row_ShowTotals", StringUtil.concat(stringArray, '#'));
            }
            if (StringUtil.notEmpty((String)(object = gO.getUserProperty("Cube_Column")))) {
                stringArray = ((String)object).split(",");
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = "Yes";
                }
                cubeGO.setUserProperty("Cube_Column_ShowTotals", StringUtil.concat(stringArray2, '#'));
            }
        }
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof CompositeDataSource)) {
            throw new IllegalArgumentException("Not a CompositeDataSource");
        }
        CompositeDataSource compositeDataSource = (CompositeDataSource)iDataSource;
        Element element = this.defineDataSource(compositeDataSource);
        element.setAttribute(VERSION, CURRENT_VERSION);
        DataSchema dataSchema = compositeDataSource.getSchema();
        if (dataSchema != null) {
            CompositeDefinition.saveSchema(dataSchema, element);
        }
        this.saveSecurity(compositeDataSource.getSecurity(), element);
        CompositeDiagram compositeDiagram = compositeDataSource.getDiagram();
        if (compositeDiagram != null) {
            Element element2;
            Element element3 = new Element(COMPOSITE, NS_DATASOURCE);
            String string = compositeDataSource.getJavaScript();
            if (string != null) {
                element2 = new Element(SCRIPT, NS_DATASOURCE);
                element2.setAttribute("space", "preserve", Namespace.XML_NAMESPACE);
                element2.setText(string);
                element3.addContent(element2);
            }
            element.addContent(element3);
            element2 = XmlUtil.saveDiagramToJDOM(compositeDiagram);
            element.addContent(element2);
        }
        return element;
    }
}

