/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.codec.BinaryCodec;
import com.elixirtech.data2.datasource.codec.CSVCodec;
import com.elixirtech.data2.datasource.codec.ConnectionPoolCodec;
import com.elixirtech.data2.datasource.codec.JSONCodec;
import com.elixirtech.data2.datasource.codec.JavaCodec;
import com.elixirtech.data2.datasource.codec.MongoDBCodec;
import com.elixirtech.data2.datasource.codec.TextCodec;
import com.elixirtech.data2.datasource.codec.XLSXCodec;
import com.elixirtech.data2.datasource.codec.XMLCodec;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.ensemble.ds.DSUtil;
import com.elixirtech.jdom.Element;
import com.elixirtech.util.collections.BeanMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class DataStoreRegistry {
    private static final Map<String, String> m_Map = new TreeMap<String, String>();
    private static final Map<String, String> m_Prefixes = new HashMap<String, String>();
    private static final Map<String, DataStoreCodec> m_Codecs = new HashMap<String, DataStoreCodec>();

    public static void register(String string, String string2, String string3) {
        m_Map.put(string, string3);
        m_Prefixes.put(string, string2);
    }

    public static String[] getNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(m_Map.keySet());
        treeSet.add("Custom Java DataStore");
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    public static String getPrefix(String string) {
        String string2 = m_Prefixes.get(string);
        if (string2 == null) {
            string2 = "Java_";
        }
        return string2;
    }

    public static DataStore buildDataStore(Element element) {
        String string = element.getAttributeValue("type");
        DataStoreCodec dataStoreCodec = m_Codecs.get(string);
        if (dataStoreCodec != null) {
            DataStore dataStore = dataStoreCodec.buildDataStore(element);
            dataStore.setName(element.getAttributeValue("name"));
            return dataStore;
        }
        return new DataStore(string);
    }

    public static Element buildElement(Node node) {
        String string = node.getUserProperty("DataStore_Type");
        DataStoreCodec dataStoreCodec = m_Codecs.get(string);
        if (dataStoreCodec != null) {
            return dataStoreCodec.buildElement(node);
        }
        return null;
    }

    public static DataStore buildDataStore(Node node) {
        Element element = new Element("holder");
        element.setAttribute("type", node.getUserProperty("DataStore_Type"));
        element.addContent(DataStoreRegistry.buildElement(node));
        return DataStoreRegistry.buildDataStore(element);
    }

    public static DataListener2 getDataListener(PushContext pushContext, DataStore dataStore) {
        String string = dataStore.getType();
        Map<String, Object> map = DSUtil.buildMap(pushContext, string, dataStore);
        String string2 = m_Map.get(string);
        if ("Custom Java DataStore".equals(string)) {
            string2 = dataStore.getProperty("Java_ClassName");
        }
        if (StringUtil.isEmpty(string2)) {
            string2 = string;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string2, true, classLoader);
            DataListener2 dataListener2 = (DataListener2)clazz.newInstance();
            BeanMap beanMap = new BeanMap(dataListener2);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string3 = entry.getKey();
                if (beanMap.getWriteMethod(string3) == null) continue;
                beanMap.put(string3, entry.getValue());
            }
            if (dataListener2 instanceof IDataStore2) {
                ((IDataStore2)dataListener2).setDataStore(dataStore);
            }
            return dataListener2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to initialize DataStore: " + String.valueOf(exception), exception);
        }
    }

    public static void registerCodec(String string, DataStoreCodec dataStoreCodec) {
        m_Codecs.put(string, dataStoreCodec);
    }

    static {
        DataStoreRegistry.register("None", "Null_", "com.elixirtech.data2.output.NullDataStore");
        DataStoreRegistry.register("Binary", "Binary_", "com.elixirtech.data2.output.BinaryDataStore");
        DataStoreRegistry.register("CSV File", "CSV_", "com.elixirtech.data2.output.CSVDataStore");
        DataStoreRegistry.register("XLSX File", "XLSX_", "com.elixirtech.data2.output.XlsxDataStore2");
        DataStoreRegistry.register("JSON File", "JSON_", "com.elixirtech.data2.output.JSONDataStore");
        DataStoreRegistry.register("Connection Pool", "JDBC_", "com.elixirtech.data2.output.JDBCConnectionPoolStore");
        DataStoreRegistry.register("XML File", "XML_", "com.elixirtech.data2.output.XMLDataStore");
        DataStoreRegistry.register("Text File", "Text_", "com.elixirtech.data2.output.TextDataStore");
        DataStoreRegistry.register("MongoDB", "MongoDB_", "com.elixirtech.data2.output.MongoDBDataStore");
        DataStoreRegistry.registerCodec("Binary", new BinaryCodec());
        DataStoreRegistry.registerCodec("CSV File", new CSVCodec());
        DataStoreRegistry.registerCodec("Custom Java DataStore", new JavaCodec());
        DataStoreRegistry.registerCodec("JSON File", new JSONCodec());
        DataStoreRegistry.registerCodec("Connection Pool", new ConnectionPoolCodec());
        DataStoreRegistry.registerCodec("Text File", new TextCodec());
        DataStoreRegistry.registerCodec("XLSX File", new XLSXCodec());
        DataStoreRegistry.registerCodec("XML File", new XMLCodec());
        DataStoreRegistry.registerCodec("MongoDB", new MongoDBCodec());
    }
}

