/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.datasource.derivative.AbstractTransformer;
import com.elixirtech.data2.datasource.derivative.Derivative;
import com.elixirtech.data2.datasource.derivative.MultiTransformer;
import com.elixirtech.data2.datasource.derivative.Prefix;
import com.elixirtech.data2.datasource.derivative.SingleTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class DerivedDataSource
extends AbstractDataSource {
    protected final IDataSource m_Parent;
    protected final String m_Name;
    protected String m_Description;
    protected DataSchema m_Schema;
    protected Set<String> m_DiscardSet = Collections.emptySet();
    protected List<Derivative> m_Derivatives = new ArrayList<Derivative>();
    protected Prefix m_Prefix = Prefix.EMPTY;
    protected boolean m_PushStarted;

    public DerivedDataSource(String string, IDataSource iDataSource) {
        this.m_Name = string;
        this.m_Parent = iDataSource;
    }

    public DerivedDataSource(String string, IDataSource iDataSource, Derivative derivative) {
        this(string, iDataSource);
        this.addDerivative(derivative);
    }

    public void setPrefix(Prefix prefix) {
        this.m_Prefix = prefix;
    }

    public Prefix getPrefix() {
        return this.m_Prefix;
    }

    public void setDiscardSet(Set<String> set) {
        this.m_DiscardSet = set;
    }

    public Set<String> getDiscardSet() {
        return this.m_DiscardSet;
    }

    public void addDerivative(Derivative derivative) {
        assert (!this.m_PushStarted) : "Can't add derivative after push started";
        this.m_Derivatives.add(derivative);
        this.m_Schema = null;
    }

    public int getDerivativeCount() {
        return this.m_Derivatives.size();
    }

    public Derivative getDerivative(int n) {
        return this.m_Derivatives.get(n);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public IDataSource getParent() {
        return this.m_Parent;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Derivative";
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Schema == null) {
            this.m_Schema = this.buildSchema();
        }
        return this.m_Schema;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_PushStarted = true;
        int n = this.m_Derivatives.size();
        if (0 == n) {
            if (this.m_Prefix == Prefix.EMPTY) {
                this.m_Parent.pushTo(pushContext, dataListener);
            } else {
                this.m_Parent.pushTo(pushContext, new PrefixTransformer(this, pushContext, dataListener));
            }
        } else if (1 == n) {
            this.m_Parent.pushTo(pushContext, new SingleTransformer(this, pushContext, dataListener));
        } else {
            this.m_Parent.pushTo(pushContext, new MultiTransformer(this, pushContext, dataListener));
        }
    }

    protected DataSchema buildSchema() {
        DataSchema dataSchema = this.m_Parent.getSchema();
        if (this.m_Derivatives.size() == 0) {
            return dataSchema;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema.isCaseSensitive());
        int n2 = dataSchema.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String object = dataSchema.getColumnName(i);
            DataType dataType = dataSchema.getColumnType(i);
            DataAttributes dataAttributes = dataSchema.getAttributes(i);
            if (!this.m_DiscardSet.contains(object)) {
                schemaBuilder.add(this.m_Prefix.apply(object), dataType, dataAttributes);
                arrayList.add(new Integer(n));
            }
            ++n;
        }
        for (Derivative derivative : this.m_Derivatives) {
            int n3 = derivative.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                String string = derivative.getColumnName(i);
                DataType dataType = derivative.getColumnType(i);
                SchemaItem schemaItem = new SchemaItem(string, dataType);
                schemaBuilder.add(schemaItem);
            }
        }
        return schemaBuilder.getSchema();
    }

    static class PrefixTransformer
    extends AbstractTransformer {
        public PrefixTransformer(DerivedDataSource derivedDataSource, PushContext pushContext, DataListener dataListener) {
            super(derivedDataSource, pushContext, dataListener);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            return this.m_DataListener.processRecord(new DataRecord(this.m_Schema, dataRecord.getData()));
        }
    }
}

