/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaHelper;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import com.elixirtech.data2.datasource.derivative.JoinDerivative;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JoinDerivativeContext
implements DerivativeContext {
    private final JoinDerivative m_Derivative;
    private final DataTable m_SecondaryTable;
    private final DataSchema m_SecondarySchema;
    private final List<Join> m_Keys = new ArrayList<Join>();
    protected DataRecord m_Record;
    protected Map<Object, List<Object>> m_Map;
    protected List<Object> m_Rows;
    protected int[] m_Offsets;
    protected int[] m_KeysPrimaryIndex;
    protected int[] m_KeysSecondaryIndex;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JoinDerivativeContext.class);

    public JoinDerivativeContext(JoinDerivative joinDerivative, PushContext pushContext) {
        this.m_Derivative = joinDerivative;
        m_Log.debug((Object)"Loading secondary table");
        this.m_SecondaryTable = DataTable.build(pushContext, this.m_Derivative.m_SecondarySource);
        if (this.m_SecondaryTable == null) {
            throw new RuntimeException("Unable to load secondary table from " + String.valueOf(this.m_Derivative.m_SecondarySource));
        }
        this.m_SecondarySchema = this.m_SecondaryTable.getSchema();
        for (JoinDerivative.JoinInfo joinInfo : this.m_Derivative.m_Keys) {
            this.m_Keys.add(new Join(joinInfo.primary, joinInfo.secondary));
        }
    }

    @Override
    public void startData(PushContext pushContext, DataSchema dataSchema, DataSchema dataSchema2) {
        int n;
        Iterator<Join> iterator = this.m_Keys.iterator();
        while (iterator.hasNext()) {
            Join join = iterator.next();
            join.setPrimarySchema(dataSchema);
            join.setSecondarySchema(this.m_SecondarySchema);
            if (join.isValid()) continue;
            m_Log.debug((Object)("Primary: " + SchemaHelper.names(dataSchema)));
            m_Log.debug((Object)("Secondary: " + SchemaHelper.names(this.m_SecondarySchema)));
            m_Log.warn((Object)("Invalid join: " + join.m_Primary + "(" + join.m_PrimaryIndex + ") = " + join.m_Secondary + "(" + join.m_SecondaryIndex + ")"));
            iterator.remove();
        }
        int n2 = this.m_Keys.size();
        this.m_KeysPrimaryIndex = new int[n2];
        this.m_KeysSecondaryIndex = new int[n2];
        for (n = 0; n < n2; ++n) {
            Join join = this.m_Keys.get(n);
            this.m_KeysPrimaryIndex[n] = join.getPrimaryIndex();
            this.m_KeysSecondaryIndex[n] = join.getSecondaryIndex();
        }
        this.m_Offsets = new int[this.m_Derivative.getColumnCount()];
        for (n = 0; n < this.m_Offsets.length; ++n) {
            this.m_Offsets[n] = dataSchema2.getColumnIndex(this.m_Derivative.getColumnName(n));
            if (this.m_Offsets[n] >= 0) continue;
            throw new IllegalArgumentException("Derivative named \"" + this.m_Derivative.getColumnName(n) + "\" not found.");
        }
        this.buildMap();
    }

    @Override
    public void endData() {
        this.m_Map = null;
        this.m_KeysPrimaryIndex = null;
        this.m_KeysSecondaryIndex = null;
    }

    @Override
    public void getData(int n, Object[] objectArray) {
        if (this.m_Rows != null) {
            Object[] objectArray2 = (Object[])this.m_Rows.get(n);
            for (int i = 0; i < this.m_Offsets.length; ++i) {
                objectArray[this.m_Offsets[i]] = objectArray2[i];
            }
        }
    }

    protected void buildMap() {
        m_Log.debug((Object)"Populating join map");
        this.m_Map = new HashMap<Object, List<Object>>();
        int n = this.m_Derivative.m_OutputSchema.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.m_SecondarySchema.getColumnIndex(this.m_Derivative.m_OutputSchema.getColumnName(i));
            if (nArray[i] >= 0) continue;
            m_Log.error((Object)("Can't locate column " + this.m_Derivative.m_OutputSchema.getColumnName(i)));
        }
        DataRecord[] dataRecordArray = this.m_SecondaryTable.getRecords();
        for (int i = 0; i < dataRecordArray.length; ++i) {
            Object object = this.getSecondaryKey(dataRecordArray[i]);
            List<Object> list = this.m_Map.get(object);
            if (list == null) {
                list = new ArrayList<Object>();
                this.m_Map.put(object, list);
            }
            Object[] objectArray = dataRecordArray[i].getData();
            Object[] objectArray2 = new Object[n];
            for (int j = 0; j < objectArray2.length; ++j) {
                objectArray2[j] = objectArray[nArray[j]];
            }
            list.add(objectArray2);
        }
        m_Log.debug((Object)("Join map complete (" + this.m_Map.size() + " entries)"));
    }

    @Override
    public void setData(DataRecord dataRecord) {
        Object object = this.getPrimaryKey(dataRecord);
        this.m_Rows = this.m_Map.get(object);
    }

    @Override
    public int getRowCount() {
        int n;
        int n2 = n = this.m_Rows == null ? 0 : this.m_Rows.size();
        if (n == 0) {
            return JoinDerivative.KEEP == this.m_Derivative.m_ZeroAction ? 1 : 0;
        }
        if (n > 1) {
            if (JoinDerivative.DISCARD == this.m_Derivative.m_MultipleAction) {
                return 0;
            }
            return JoinDerivative.KEEP == this.m_Derivative.m_MultipleAction ? 1 : n;
        }
        return 1;
    }

    protected Object getPrimaryKey(DataRecord dataRecord) {
        int n = this.m_KeysPrimaryIndex.length;
        if (n == 1) {
            Object object = dataRecord.getData(this.m_KeysPrimaryIndex[0]);
            if (object == null) {
                return JoinDerivative.NULL_KEY;
            }
            return object;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = dataRecord.getData(this.m_KeysPrimaryIndex[i]);
        }
        return new JoinDerivative.MultiKey(objectArray);
    }

    protected Object getSecondaryKey(DataRecord dataRecord) {
        int n = this.m_KeysSecondaryIndex.length;
        if (n == 1) {
            Object object = dataRecord.getData(this.m_KeysSecondaryIndex[0]);
            if (object == null) {
                return JoinDerivative.NULL_KEY;
            }
            return object;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = dataRecord.getData(this.m_KeysSecondaryIndex[i]);
        }
        return new JoinDerivative.MultiKey(objectArray);
    }

    public static final class Join {
        private final String m_Primary;
        private final String m_Secondary;
        private int m_PrimaryIndex;
        private int m_SecondaryIndex;

        public Join(String string, String string2) {
            this.m_Primary = string;
            this.m_Secondary = string2;
        }

        public void setPrimarySchema(DataSchema dataSchema) {
            this.m_PrimaryIndex = dataSchema.getColumnIndex(this.m_Primary);
        }

        public void setSecondarySchema(DataSchema dataSchema) {
            this.m_SecondaryIndex = dataSchema.getColumnIndex(this.m_Secondary);
        }

        public String getPrimaryKey() {
            return this.m_Primary;
        }

        public int getPrimaryIndex() {
            return this.m_PrimaryIndex;
        }

        public String getSecondaryKey() {
            return this.m_Secondary;
        }

        public int getSecondaryIndex() {
            return this.m_SecondaryIndex;
        }

        public boolean isValid() {
            return this.m_PrimaryIndex >= 0 && this.m_SecondaryIndex >= 0;
        }

        public String getPrimaryName() {
            return this.m_Primary;
        }

        public String getSecondaryName() {
            return this.m_Secondary;
        }
    }
}

