/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.excel;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.datasource.excel.Range;
import com.elixirtech.data2.xlsx.Workbook;
import java.awt.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XRangeBuilder {
    private static final Pattern CELL = Pattern.compile("(\\$)?([A-Z]+)(\\$)?([0-9]+)");

    public static Range getRange(Workbook workbook, String string) {
        if (string.startsWith("=")) {
            return XRangeBuilder.buildEqualsRange(workbook, string);
        }
        com.elixirtech.data2.xlsx.Range range = workbook.getRange(string);
        if (range != null) {
            Range range2 = new Range(range.left, range.top, range.right, range.bottom);
            range2.firstSheet = range.firstSheet;
            range2.lastSheet = range.lastSheet;
            return range2;
        }
        return null;
    }

    private static Range buildEqualsRange(Workbook workbook, String string) {
        String[] stringArray;
        Range range = new Range();
        range.right = 255;
        range.bottom = Integer.MAX_VALUE;
        String string2 = string.substring(1);
        String[] stringArray2 = string2.split("!");
        if (stringArray2.length > 0 && StringUtil.notEmpty(stringArray2[0])) {
            stringArray = stringArray2[0].split(":");
            range.firstSheet = XRangeBuilder.getSheetIndex(workbook, stringArray[0]);
            range.lastSheet = stringArray.length > 1 ? XRangeBuilder.getSheetIndex(workbook, stringArray[1]) : range.firstSheet;
        } else {
            range.firstSheet = 0;
            range.lastSheet = 0;
            for (int i = 1; i < workbook.getSheetCount(); ++i) {
                if (workbook.getSheet(i).getRowCount() <= 0) continue;
                range.lastSheet = i;
            }
        }
        if (stringArray2.length > 1 && (stringArray = stringArray2[1].split(":")).length > 0) {
            Point point = XRangeBuilder.getCellIndex(stringArray[0]);
            range.left = point.x;
            range.top = point.y;
            if (stringArray.length > 1) {
                point = XRangeBuilder.getCellIndex(stringArray[1]);
                range.right = point.x;
                range.bottom = point.y;
            }
        }
        return range;
    }

    private static int getSheetIndex(Workbook workbook, String string) {
        return workbook.getSheetIndex(string);
    }

    private static Point getCellIndex(String string) {
        Point point = new Point(-1, -1);
        Matcher matcher = CELL.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            String string3 = matcher.group(4);
            point.x = string2.length() == 1 ? string2.charAt(0) - 65 : (string2.charAt(0) - 65 + 1) * 26 + string2.charAt(1) - 65;
            try {
                point.y = Integer.parseInt(string3) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return point;
    }
}

