/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;

public abstract class ComparatorFilter
implements Filter {
    protected final String m_Name;
    protected final String m_Value;
    protected int m_Index;
    protected Comparable m_Test;

    public ComparatorFilter(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        this.m_Name = string;
        this.m_Value = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getValue() {
        return this.m_Value;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_Value);
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_Index = dataSchema.getColumnIndex(this.m_Name);
        if (this.m_Index >= 0) {
            DataType dataType = dataSchema.getColumnType(this.m_Index);
            this.m_Test = (Comparable)dataSchema.parse(dataType, pushContext.substitute(this.m_Value));
            this.m_Test = ComparatorFilter.ensureNumberIsDouble(this.m_Test);
        }
    }

    protected static Comparable ensureNumberIsDouble(Comparable comparable) {
        if (comparable instanceof Number && !(comparable instanceof Double)) {
            return Double.valueOf(((Number)((Object)comparable)).doubleValue());
        }
        return comparable;
    }

    @Override
    public abstract boolean accept(DataRecord var1);
}

