/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import java.util.Calendar;
import java.util.Date;

public class DateFilter
implements Filter {
    public static final String TYPE = "Date";
    protected final String m_Name;
    protected final int m_Field;
    protected final int m_Value;
    protected final Calendar m_Calendar;
    protected int m_Index;

    public DateFilter(String string, int n, int n2) {
        this.m_Name = string;
        this.m_Field = n;
        this.m_Value = n2;
        this.m_Calendar = Calendar.getInstance();
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.m_Value);
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_Index = dataSchema.getColumnIndex(this.m_Name);
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        Object object = dataRecord.getData(this.m_Index);
        if (object == null) {
            return false;
        }
        this.m_Calendar.setTime((Date)object);
        return this.m_Calendar.get(this.m_Field) == this.m_Value;
    }
}

