/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.ComparatorFilter;
import com.elixirtech.data2.datasource.filter.Filter;

public class EqualsFilter
implements Filter {
    public static final String TYPE = "Equals";
    protected final String m_Name;
    protected final String m_Value;
    protected int m_Index;
    protected Object m_Test;

    public EqualsFilter(String string, String string2) {
        assert (string != null);
        this.m_Name = string;
        this.m_Value = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.m_Value;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_Value);
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_Index = dataSchema.getColumnIndex(this.m_Name);
        if (this.m_Index >= 0) {
            DataType dataType = dataSchema.getColumnType(this.m_Index);
            this.m_Test = dataSchema.parse(dataType, pushContext.substitute(this.m_Value));
            if (this.m_Test instanceof Comparable) {
                this.m_Test = ComparatorFilter.ensureNumberIsDouble((Comparable)this.m_Test);
            }
        }
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        if (this.m_Index < 0) {
            return false;
        }
        Object object = dataRecord.getData(this.m_Index);
        if (object == null) {
            return this.m_Test == null;
        }
        if (object instanceof Comparable) {
            object = ComparatorFilter.ensureNumberIsDouble((Comparable)object);
        }
        return object.equals(this.m_Test);
    }
}

