/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.filter.AndFilter;
import com.elixirtech.data2.datasource.filter.CompositeFilter;
import com.elixirtech.data2.datasource.filter.EqualsFilter;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.FilteredDataSource;
import com.elixirtech.data2.datasource.filter.ICompositeFilter;
import com.elixirtech.data2.datasource.filter.InDataSetFilter;
import com.elixirtech.data2.datasource.filter.InRangeFilter;
import com.elixirtech.data2.datasource.filter.JavaScriptFilter;
import com.elixirtech.data2.datasource.filter.LessThanFilter;
import com.elixirtech.data2.datasource.filter.MoreThanFilter;
import com.elixirtech.data2.datasource.filter.NotWrapper;
import com.elixirtech.data2.datasource.filter.NullFilter;
import com.elixirtech.data2.datasource.filter.OrFilter;
import com.elixirtech.data2.datasource.filter.RegExpFilter;
import com.elixirtech.data2.datasource.filter.SelectionFilter;
import com.elixirtech.data2.datasource.filter.UnsupportedFilter;
import com.elixirtech.jdom.Element;
import java.util.Iterator;
import java.util.List;

public class FilteredDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("filter", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load filter element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        FilteredDataSource filteredDataSource = new FilteredDataSource(string, iDataSource);
        this.build(filteredDataSource, element2);
        return filteredDataSource;
    }

    private void build(ICompositeFilter iCompositeFilter, Element element) {
        Object object;
        String string;
        List<Element> list = element.getChildren("composite", NS_DATASOURCE);
        for (Element element2 : list) {
            string = element2.getAttributeValue("type");
            object = null;
            if ("And".equals(string)) {
                object = new AndFilter();
            } else if ("Or".equals(string)) {
                object = new OrFilter();
            }
            if (object == null) continue;
            this.build((ICompositeFilter)object, element2);
            iCompositeFilter.addFilter((Filter)object);
        }
        list = element.getChildren("item", NS_DATASOURCE);
        for (Element element2 : list) {
            string = element2.getAttributeValue("name");
            object = element2.getAttributeValue("when");
            String string2 = element2.getAttributeValue("condition");
            Filter filter = FilteredDefinition.getFilter(string, (String)object, string2);
            iCompositeFilter.addFilter(filter);
        }
    }

    public static Filter getFilter(String string, String string2, String string3) {
        if (string2.equals("Equals")) {
            return new EqualsFilter(string, string3);
        }
        if (string2.equals("More Than")) {
            return new MoreThanFilter(string, string3);
        }
        if (string2.equals("Less Than")) {
            return new LessThanFilter(string, string3);
        }
        if (string2.equals("Null")) {
            return new NullFilter(string);
        }
        if (string2.equals("RegExp")) {
            return new RegExpFilter(string, string3);
        }
        if (string2.equals("Matches")) {
            return new RegExpFilter(string, string3);
        }
        if (string2.equals("JavaScript")) {
            return new JavaScriptFilter(string3);
        }
        if (string2.equals("Selection")) {
            return new SelectionFilter(string, string3);
        }
        if (string2.equals("In DataSet")) {
            return new InDataSetFilter(string, string3);
        }
        if (string2.equals("In Range")) {
            return new InRangeFilter(string, string3);
        }
        if (string2.startsWith("Not ")) {
            String string4 = string2.substring("Not ".length());
            return new NotWrapper(FilteredDefinition.getFilter(string, string4, string3));
        }
        return new UnsupportedFilter(string, string2, string3);
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof FilteredDataSource)) {
            throw new IllegalArgumentException("Not a FilteredDataSource");
        }
        FilteredDataSource filteredDataSource = (FilteredDataSource)iDataSource;
        Element element = this.defineDataSource(filteredDataSource);
        Element element2 = new Element("filter", NS_DATASOURCE);
        element2.setAttribute("parent", filteredDataSource.getParent().getName());
        int n = filteredDataSource.getFilterCount();
        for (int i = 0; i < n; ++i) {
            Filter filter = filteredDataSource.getFilter(i);
            Element element3 = this.getItem(filter);
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }

    protected Element getItem(Filter filter) {
        if (filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)filter;
            Element element = new Element("composite", NS_DATASOURCE);
            element.setAttribute("type", compositeFilter.getName());
            Iterator<Filter> iterator = compositeFilter.getFilters();
            while (iterator.hasNext()) {
                Filter filter2 = iterator.next();
                element.addContent(this.getItem(filter2));
            }
            return element;
        }
        Element element = new Element("item", NS_DATASOURCE);
        element.setAttribute("name", filter.getName());
        element.setAttribute("when", filter.getType());
        element.setAttribute("condition", filter.getValue());
        return element;
    }
}

