/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.SetExtractor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InDataSetFilter
implements Filter {
    public static final String TYPE = "In DataSet";
    protected final String m_Name;
    protected final String m_Value;
    protected int m_Index;
    protected Set<Object> m_Set = new HashSet<Object>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(InDataSetFilter.class);

    public InDataSetFilter(String string, String string2) {
        assert (string != null);
        this.m_Name = string;
        this.m_Value = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.m_Value;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_Value);
    }

    public String getDataSourceName() {
        int n = this.m_Value.lastIndexOf(":");
        if (n > 0) {
            return this.m_Value.substring(0, n);
        }
        return "";
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        String string = pushContext.substitute(this.m_Value);
        int n = string.lastIndexOf(":");
        this.m_Set.clear();
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.m_Index = dataSchema.getColumnIndex(this.m_Name);
            if (this.m_Index >= 0) {
                DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string2);
                if (iDataSource != null) {
                    int n2 = iDataSource.getSchema().getColumnIndex(string3);
                    if (n2 >= 0) {
                        SetExtractor setExtractor = new SetExtractor(n2);
                        iDataSource.pushTo(pushContext, setExtractor);
                        this.m_Set = setExtractor.getSet();
                    } else {
                        String string4 = InDataSetFilter.getCols(iDataSource.getSchema());
                        m_Log.warn((Object)("Can't locate index of " + string3 + " in " + string4));
                        this.m_Set = Collections.emptySet();
                    }
                } else {
                    m_Log.warn((Object)("Can't locate datasource " + string2 + " (" + string + ")"));
                    this.m_Set = Collections.emptySet();
                }
            }
        }
    }

    private static String getCols(DataSchema dataSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dataSchema.getColumnName(i));
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        return this.m_Set.contains(dataRecord.getData(this.m_Index));
    }
}

