/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import ambience.api.JDBCConnectionPools;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Parameter;
import com.elixirtech.jdom.Element;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class JDBCConnector
implements Comparable<JDBCConnector> {
    public static final String ID = "jdbc-connector";
    public static final String TYPE_DRIVER = "driver";
    public static final String TYPE_POOL = "pool";
    public static final String TYPE_JNDI = "jndi";
    public static final String TYPE = "type";
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String POOL = "pool";
    public static final String TIMEOUT = "timeout";
    public static final String CONTEXT_FACTORY = "context-factory";
    public static final String RESOURCE_NAME = "resource-name";
    public String name;

    public static JDBCConnector load(Element element) {
        String string = element.getAttributeValue(TYPE);
        if ("pool".equals(string)) {
            return new Pool(element);
        }
        throw new IllegalArgumentException("Unsupported connector type: " + string);
    }

    public abstract String getType();

    public abstract int getIntType();

    public abstract Connection getConnection(ArgumentMap.ICallback var1) throws SQLException;

    public abstract Element save();

    public abstract void extractParameters(ArgumentMap var1);

    public abstract JDBCConnector substitute(ArgumentMap.ICallback var1);

    public abstract String getDescription();

    protected static boolean equal(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    protected static void setAttribute(Element element, String string, String string2) {
        if (StringUtil.notEmpty(string2)) {
            element.setAttribute(string, string2);
        }
    }

    @Override
    public int compareTo(JDBCConnector jDBCConnector) {
        return this.name.compareTo(jDBCConnector.name);
    }

    public static class Pool
    extends JDBCConnector {
        public String pool;
        public long timeout;

        public Pool() {
        }

        private Pool(Element element) {
            assert (this.getType().equals(element.getAttributeValue(JDBCConnector.TYPE)));
            this.name = element.getAttributeValue(JDBCConnector.NAME);
            this.pool = element.getAttributeValue("pool");
            try {
                this.timeout = Long.parseLong(element.getAttributeValue(JDBCConnector.TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Pool)) {
                return false;
            }
            Pool pool = (Pool)object;
            if (!Pool.equal(pool.name, this.name)) {
                return false;
            }
            if (!Pool.equal(pool.pool, this.pool)) {
                return false;
            }
            return pool.timeout == this.timeout;
        }

        @Override
        public String getDescription() {
            return this.pool;
        }

        @Override
        public String getType() {
            return "pool";
        }

        @Override
        public int getIntType() {
            return 3;
        }

        @Override
        public Connection getConnection(ArgumentMap.ICallback iCallback) throws SQLException {
            try {
                return ((JDBCConnectionPools)Elixir.get(JDBCConnectionPools.class)).getConnectionJ(this.pool);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw new SQLException("Can't load pool: " + this.pool, exception);
            }
        }

        @Override
        public Element save() {
            Element element = new Element(JDBCConnector.ID);
            Pool.setAttribute(element, JDBCConnector.TYPE, this.getType());
            Pool.setAttribute(element, JDBCConnector.NAME, this.name);
            Pool.setAttribute(element, "pool", this.pool);
            Pool.setAttribute(element, JDBCConnector.TIMEOUT, String.valueOf(this.timeout));
            return element;
        }

        @Override
        public void extractParameters(ArgumentMap argumentMap) {
            argumentMap.extractParameters(this.pool);
            for (Parameter parameter : argumentMap.getParameters()) {
                if (!parameter.getName().startsWith("url:")) continue;
                argumentMap.removeParameter(parameter.getName());
            }
        }

        @Override
        public JDBCConnector substitute(ArgumentMap.ICallback iCallback) {
            Pool pool = new Pool();
            pool.pool = ArgumentMap.substitute(this.pool, iCallback);
            pool.timeout = this.timeout;
            return pool;
        }
    }
}

