/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.RemoteMarker;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.attributes.Nullable;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.data2.datasource.jdbc.JDBCConstants;
import com.elixirtech.data2.datasource.jdbc.JDBCDataIterator;
import com.elixirtech.data2.datasource.jdbc.JDBCProcessor;
import com.elixirtech.data2.datasource.jdbc.StringCache;
import com.elixirtech.data2.iterator.IDataRecordIterable;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import com.elixirtech.jdom.Element;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scala.collection.immutable.Map;

public final class JDBCDataSource
extends FileBasedDataSource
implements JDBCConstants,
IDataRecordIterable {
    public static final int TYPE_POOL = 3;
    protected String m_Name;
    protected DataSchema m_Schema;
    protected int[] m_ColumnTypes;
    protected String m_Description;
    protected JDBCConnector.Pool m_Connector = JDBCDataSource.buildDefaultConnector();
    protected String m_SQL = "";
    protected long m_KeepAlive;
    protected String m_MaxRows;
    protected String m_Timeout;
    protected String m_FetchSize;
    protected boolean m_IsCallableStatement;
    protected boolean m_IsAutoCommit = true;
    protected boolean m_IsReadOnly = true;
    protected String m_OutTypeValue;
    protected int m_OutType;
    protected int m_OutTypeScale;
    protected List<InParameter> m_InParameters = new ArrayList<InParameter>();
    protected ArgumentMap m_Arguments = new ArgumentMap();
    protected boolean m_ArgsChanged;
    protected boolean m_NullsToStrings;
    protected Element m_QBXML;
    protected JDBCProcessor m_Processor;
    protected int[] m_ResultSetIndices;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCDataSource.class);

    public JDBCDataSource() {
        this("", new DataSchema());
    }

    public JDBCDataSource(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
        this.m_ArgsChanged = true;
        this.buildColumnTypes();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataRecordIterable.class) {
            return clazz.cast(this);
        }
        if (clazz == JDBCDataSource.class) {
            return clazz.cast(this);
        }
        return super.getAdapter(clazz);
    }

    public void setNullsToStrings(boolean bl) {
        this.m_NullsToStrings = bl;
    }

    public boolean isNullsToStrings() {
        return this.m_NullsToStrings;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return "JDBC";
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public String getFetchSize() {
        return this.m_FetchSize;
    }

    public void setFetchSize(String string) {
        if (JDBCDataSource.changed(this.m_FetchSize, string)) {
            this.m_FetchSize = string;
            this.m_ArgsChanged = true;
            this.setDirty(true);
        }
    }

    public String getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(String string) {
        if (JDBCDataSource.changed(this.m_Timeout, string)) {
            this.m_Timeout = string;
            this.m_ArgsChanged = true;
            this.setDirty(true);
        }
    }

    public void setConnector(JDBCConnector.Pool pool) {
        this.m_Connector = pool;
        this.m_ArgsChanged = true;
        this.setDirty(true);
    }

    public JDBCConnector.Pool getConnector() {
        return this.m_Connector;
    }

    public Element getQBXML() {
        return this.m_QBXML;
    }

    public void setQBXML(Element element) {
        this.m_QBXML = element;
    }

    @Override
    public IDataRecordIterator iterator(Map<String, String> map) {
        return new JDBCDataIterator(this, map);
    }

    public DataSchema inferSchema(PushContext pushContext) throws DataException {
        try {
            Object object;
            SchemaBuilder schemaBuilder = new SchemaBuilder(true);
            ResultSet resultSet = this.getResultSet(pushContext);
            if (resultSet != null) {
                object = resultSet.getMetaData();
                int n = object.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string = object.getColumnLabel(i);
                    int n2 = object.getColumnType(i);
                    DataType dataType = JDBCDataSource.getDataTypeFromJDBC(n2);
                    DataAttributes dataAttributes = new DataAttributes();
                    int n3 = object.isNullable(i);
                    if (n3 == 0) {
                        dataAttributes.addAttribute(new Nullable(false));
                    } else if (n3 == 1) {
                        dataAttributes.addAttribute(new Nullable(true));
                    }
                    schemaBuilder.add(string, dataType, dataAttributes);
                }
            }
            object = schemaBuilder.getSchema();
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataException("Error extracting metadata: " + String.valueOf(sQLException), sQLException);
        }
        finally {
            if (this.m_Processor != null) {
                this.m_Processor.close();
            }
            this.m_Processor = null;
        }
    }

    public static DataType getDataTypeFromJDBC(int n) {
        DataType dataType = DataType.UNKNOWN;
        switch (n) {
            case -9: 
            case -1: 
            case 12: {
                dataType = DataType.STRING;
                break;
            }
            case -15: 
            case 1: {
                dataType = DataType.STRING;
                break;
            }
            case -7: 
            case 16: {
                dataType = DataType.BOOLEAN;
                break;
            }
            case 2004: {
                dataType = DataType.BYTE_ARRAY;
                break;
            }
            case 2005: {
                dataType = DataType.STRING;
                break;
            }
            case 91: {
                dataType = DataType.DATE;
                break;
            }
            case 6: 
            case 8: {
                dataType = DataType.DOUBLE;
                break;
            }
            case 4: {
                dataType = DataType.LONG;
                break;
            }
            case 7: {
                dataType = DataType.DOUBLE;
                break;
            }
            case -5: {
                dataType = DataType.LONG;
                break;
            }
            case 5: {
                dataType = DataType.LONG;
                break;
            }
            case 92: {
                dataType = DataType.TIME;
                break;
            }
            case 93: {
                dataType = DataType.TIMESTAMP;
                break;
            }
            case -6: {
                dataType = DataType.LONG;
                break;
            }
            case 2: {
                dataType = DataType.DOUBLE;
                break;
            }
            case 3: {
                dataType = DataType.DECIMAL;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                dataType = DataType.BYTE_ARRAY;
                break;
            }
        }
        return dataType;
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.m_ArgsChanged) {
            this.m_Arguments.resetParameters();
            this.m_Connector.extractParameters(this.m_Arguments);
            this.m_Arguments.extractParameters(this.m_SQL);
            this.m_Arguments.extractParameters(this.m_OutTypeValue);
            this.m_Arguments.extractParameters(this.m_MaxRows);
            this.m_Arguments.extractParameters(this.m_Timeout);
            this.m_Arguments.extractParameters(this.m_FetchSize);
            this.addInParameters();
            this.m_ArgsChanged = false;
        }
        return this.m_Arguments.getParameters();
    }

    private void addInParameters() {
        if (this.m_InParameters == null || this.m_InParameters.size() < 1) {
            return;
        }
        for (InParameter inParameter : this.m_InParameters) {
            this.m_Arguments.extractParameters(inParameter.value);
        }
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        assert (Elixir.get(RemoteMarker.class) == null);
        StringCache stringCache = new StringCache();
        int n = 0;
        try (JDBCProcessor jDBCProcessor = null;){
            int n2;
            m_Log.debug((Object)"start data request");
            jDBCProcessor = new JDBCProcessor(this);
            jDBCProcessor.connect(pushContext);
            ResultSet resultSet = null;
            if (this.isCallableStatement()) {
                Object object = jDBCProcessor.executeCallableStatement(pushContext);
                if (!(object instanceof ResultSet)) {
                    m_Log.debug((Object)"end data request and start process data, non resultset");
                    dataListener.startData(this);
                    Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
                    DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray);
                    objectArray[0] = this.narrowDataByIndex(object, 0);
                    pushContext.throb();
                    dataListener.processRecord(dataRecord);
                    dataListener.endData(this);
                    m_Log.debug((Object)"completed processing data, non resultset");
                    return;
                }
                resultSet = (ResultSet)object;
            } else {
                resultSet = jDBCProcessor.executeStatement(pushContext);
            }
            int n3 = this.m_Schema.getColumnCount();
            m_Log.debug((Object)("end data request and start processing data, resultset:" + String.valueOf(resultSet)));
            dataListener.startData(this);
            int[] nArray = null;
            if (this.m_ResultSetIndices != null) {
                nArray = this.m_ResultSetIndices;
            } else {
                nArray = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    try {
                        nArray[n2] = resultSet.findColumn(this.m_Schema.getColumnName(n2));
                        continue;
                    }
                    catch (SQLException sQLException) {
                        m_Log.warn((Object)("Can't locate column \"" + this.m_Schema.getColumnName(n2) + "\""));
                        nArray[n2] = -1;
                    }
                }
            }
            n2 = 0;
            while (resultSet.next()) {
                Object[] objectArray = new Object[n3];
                if (this.m_NullsToStrings) {
                    for (var11_18 = 0; var11_18 < n3; ++var11_18) {
                        try {
                            if (nArray[var11_18] >= 0) {
                                objectArray[var11_18] = JDBCDataSource.getDataFromIndex(resultSet, nArray[var11_18], this.m_ColumnTypes[var11_18], stringCache);
                            }
                            if (objectArray[var11_18] != null || this.m_ColumnTypes[var11_18] != 2) continue;
                            objectArray[var11_18] = "";
                            continue;
                        }
                        catch (Exception exception) {
                            m_Log.warn((Object)("Can't get data from result set index " + nArray[var11_18] + "(" + this.m_Schema.getColumnName(var11_18) + ")"), (Throwable)exception);
                        }
                    }
                } else {
                    for (var11_18 = 0; var11_18 < n3; ++var11_18) {
                        try {
                            if (nArray[var11_18] < 0) continue;
                            objectArray[var11_18] = JDBCDataSource.getDataFromIndex(resultSet, nArray[var11_18], this.m_ColumnTypes[var11_18], stringCache);
                            continue;
                        }
                        catch (Exception exception) {
                            m_Log.warn((Object)("Can't get data from result set index " + nArray[var11_18] + "(" + this.m_Schema.getColumnName(var11_18) + ")"), (Throwable)exception);
                        }
                    }
                }
                if (++n2 == 500) {
                    pushContext.throb();
                    n2 = 0;
                }
                if (!dataListener.processRecord(new DataRecord(this.m_Schema, objectArray))) break;
                ++n;
            }
            dataListener.endData(this);
            m_Log.debug((Object)("completed processing data, resultset:" + String.valueOf(resultSet)));
        }
    }

    public void setName(String string) {
        if (JDBCDataSource.changed(this.m_Name, string)) {
            this.m_Name = string;
            this.setDirty(true);
        }
    }

    public void setSchema(DataSchema dataSchema) {
        if (JDBCDataSource.changed(this.m_Schema, dataSchema)) {
            this.m_Schema = dataSchema;
            this.buildColumnTypes();
            this.setDirty(true);
        }
    }

    public void setDescription(String string) {
        if (JDBCDataSource.changed(this.m_Description, string)) {
            this.m_Description = string;
            this.setDirty(true);
        }
    }

    public void setReuseKeepAlive(long l) {
        if (this.m_KeepAlive != l) {
            this.m_KeepAlive = l;
            this.setDirty(true);
        }
    }

    public long getReuseKeepAlive() {
        return this.m_KeepAlive;
    }

    public void setSQL(String string) {
        if (JDBCDataSource.changed(this.m_SQL, string)) {
            this.m_SQL = string;
            this.m_ArgsChanged = true;
            this.setDirty(true);
        }
    }

    public String getSQL() {
        return this.m_SQL;
    }

    public void setMaxRows(String string) {
        if (JDBCDataSource.changed(this.m_MaxRows, string)) {
            this.m_MaxRows = string;
            this.m_ArgsChanged = true;
            this.setDirty(true);
        }
    }

    public String getMaxRows() {
        return this.m_MaxRows;
    }

    public void setCallableStatement(boolean bl) {
        if (this.m_IsCallableStatement != bl) {
            this.m_IsCallableStatement = bl;
            this.setDirty(true);
        }
    }

    public boolean isCallableStatement() {
        return this.m_IsCallableStatement;
    }

    public void setAutoCommit(boolean bl) {
        if (this.m_IsAutoCommit != bl) {
            this.m_IsAutoCommit = bl;
            this.setDirty(true);
        }
    }

    public boolean isAutoCommit() {
        return this.m_IsAutoCommit;
    }

    public void setReadOnly(boolean bl) {
        if (this.m_IsReadOnly != bl) {
            this.m_IsReadOnly = bl;
            this.setDirty(true);
        }
    }

    public boolean isReadOnly() {
        return this.m_IsReadOnly;
    }

    public void setOutTypeValue(String string) {
        this.m_OutTypeValue = string;
        this.setDirty(true);
    }

    public String getOutTypeValue() {
        return this.m_OutTypeValue;
    }

    public int getOutType() {
        int n = this.getOutType(this.m_OutTypeValue);
        return n;
    }

    public void setOutTypeScale(int n) {
        if (this.m_OutTypeScale != n) {
            this.m_OutTypeScale = n;
            this.setDirty(true);
        }
    }

    public int getOutTypeScale() {
        return this.m_OutTypeScale;
    }

    public void setInParameters(List<InParameter> list) {
        this.m_InParameters = list;
        this.setDirty(true);
        this.m_ArgsChanged = true;
    }

    public void addInParameter(InParameter inParameter) {
        this.m_InParameters.add(inParameter);
        this.setDirty(true);
        this.m_ArgsChanged = true;
    }

    public void setInParameters(String string) {
        this.m_InParameters = JDBCDataSource.buildParamList(string);
        this.setDirty(true);
        this.m_ArgsChanged = true;
    }

    public String getInParametersString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<InParameter> iterator = this.getInParameters().iterator();
        while (iterator.hasNext()) {
            InParameter inParameter = iterator.next();
            stringBuilder.append(inParameter.type);
            stringBuilder.append(",");
            stringBuilder.append(inParameter.value);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public List<InParameter> getInParameters() {
        return this.m_InParameters;
    }

    public void setResultSetIndices(int[] nArray) {
        if (nArray.length != this.m_Schema.getColumnCount()) {
            throw new IllegalArgumentException("Schema contains " + this.m_Schema.getColumnCount() + " columns, only " + nArray.length + " indices supplied");
        }
        this.m_ResultSetIndices = nArray;
        this.setDirty(true);
    }

    public int[] getResultSetIndices() {
        return this.m_ResultSetIndices;
    }

    protected ResultSet getResultSet(PushContext pushContext) throws DataException, SQLException {
        this.m_Processor = new JDBCProcessor(this);
        this.m_Processor.connect(pushContext);
        ResultSet resultSet = null;
        try {
            if (this.isCallableStatement()) {
                Object object = this.m_Processor.executeCallableStatement(pushContext);
                if (object instanceof ResultSet) {
                    resultSet = (ResultSet)object;
                }
            } else {
                resultSet = this.m_Processor.executeStatement(pushContext);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("ResultSet error: " + String.valueOf(exception)), (Throwable)exception);
        }
        return resultSet;
    }

    public static Object getDataFromIndex(ResultSet resultSet, int n, int n2, StringCache stringCache) throws SQLException {
        switch (n2) {
            case 3: {
                boolean bl = resultSet.getBoolean(n);
                if (!bl && resultSet.wasNull()) {
                    return null;
                }
                return bl;
            }
            case 8: {
                long l = resultSet.getLong(n);
                if (l == 0L && resultSet.wasNull()) {
                    return null;
                }
                return l;
            }
            case 6: {
                double d = resultSet.getDouble(n);
                if (d == 0.0 && resultSet.wasNull()) {
                    return null;
                }
                return d;
            }
            case 2: {
                return stringCache.get(resultSet.getString(n));
            }
            case 4: {
                Date date = null;
                try {
                    date = resultSet.getDate(n);
                    if (date == null) {
                        return null;
                    }
                    return new java.util.Date(date.getTime());
                }
                catch (SQLException sQLException) {
                    m_Log.warn((Object)("Error reading date: " + String.valueOf(sQLException)));
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    if (timestamp == null) {
                        return null;
                    }
                    return new java.util.Date(timestamp.getTime());
                }
            }
            case 12: {
                Time time = resultSet.getTime(n);
                if (time == null) {
                    return null;
                }
                return new java.util.Date(time.getTime());
            }
            case 13: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                if (timestamp == null) {
                    return null;
                }
                return new java.util.Date(timestamp.getTime());
            }
            case 17: {
                return resultSet.getBytes(n);
            }
            case 18: {
                return resultSet.getBigDecimal(n);
            }
        }
        m_Log.warn((Object)("getData can't read type " + DataType.getInstance(n2).getTypeName() + " with id " + n2));
        return null;
    }

    private Object narrowDataByIndex(Object object, int n) throws SQLException {
        switch (this.m_ColumnTypes[n]) {
            case 3: {
                if (object instanceof Boolean) {
                    return object;
                }
                return Boolean.valueOf(object.toString());
            }
            case 8: {
                if (object instanceof Long) {
                    return object;
                }
                return Long.valueOf(object.toString());
            }
            case 6: {
                if (object instanceof Double) {
                    return object;
                }
                return Double.valueOf(object.toString());
            }
            case 2: {
                if (object instanceof String) {
                    return object;
                }
                return object.toString();
            }
            case 4: {
                if (object instanceof Date) {
                    return new java.util.Date(((Date)object).getTime());
                }
                if (!(object instanceof Timestamp)) break;
                Timestamp timestamp = (Timestamp)object;
                return new java.util.Date(timestamp.getTime());
            }
            case 12: {
                if (!(object instanceof Time)) break;
                return new java.util.Date(((Time)object).getTime());
            }
            case 13: {
                if (!(object instanceof Timestamp)) break;
                return new java.util.Date(((Timestamp)object).getTime());
            }
            case 17: {
                if (object instanceof byte[]) {
                    return object;
                }
                return null;
            }
            case 18: {
                if (object instanceof BigDecimal) {
                    return object;
                }
                if (object instanceof BigInteger) {
                    return new BigDecimal((BigInteger)object);
                }
                return new BigDecimal(object.toString());
            }
            default: {
                m_Log.warn((Object)("getData can't read type " + this.m_Schema.getColumnType(n).getTypeName()));
                return null;
            }
        }
        return null;
    }

    private static List<InParameter> buildParamList(String string) {
        ArrayList<InParameter> arrayList = new ArrayList<InParameter>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            arrayList.add(new InParameter(stringArray[i], stringArray[i + 1]));
        }
        return arrayList;
    }

    private int getOutType(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n = string.lastIndexOf(".");
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                try {
                    Class<?> clazz = Class.forName(string2);
                    Field field = clazz.getField(string3);
                    return field.getInt(clazz);
                }
                catch (Exception exception) {
                    m_Log.error((Object)("getOutType(" + string + ") : " + String.valueOf(exception)));
                }
            }
            return 0;
        }
    }

    private void buildColumnTypes() {
        this.m_ColumnTypes = new int[this.m_Schema.getColumnCount()];
        for (int i = 0; i < this.m_ColumnTypes.length; ++i) {
            this.m_ColumnTypes[i] = this.m_Schema.getColumnType(i).getTypeId();
        }
    }

    private static JDBCConnector.Pool buildDefaultConnector() {
        JDBCConnector.Pool pool = new JDBCConnector.Pool();
        pool.name = "";
        pool.pool = "";
        return pool;
    }

    public static class InParameter {
        public final DataType type;
        public final String value;

        public InParameter(String string, String string2) {
            this.type = DataType.getInstance(string);
            this.value = string2;
        }
    }
}

