/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.ldap;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.ldap.LDAPDataSource;
import com.elixirtech.jdom.Element;

public class LDAPDefinition
extends DataSourceDefinition
implements Data2Constants {
    public static final String LOCATION = "location";
    public static final String DN = "dn";
    public static final String FILTER = "filter";
    public static final String PORT = "port";
    public static final String TIMEOUT = "timeout";
    public static final String BATCHSIZE = "batchsize";
    public static final String AUTHENTICATIONTYPE = "authentication-type";
    public static final String PRINCIPLE = "principle";
    public static final String CREDENTIALS = "credentials";
    public static final String PROTOCOL = "protocol";
    public static final String SCOPE = "scope";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = LDAPDefinition.loadSchema(element2);
        Element element3 = element.getChild("ldap", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load ldap element");
        }
        LDAPDataSource lDAPDataSource = new LDAPDataSource(string, dataSchema);
        lDAPDataSource.setDescription(element3.getAttributeValue("description"));
        lDAPDataSource.setLocation(element3.getAttributeValue(LOCATION));
        lDAPDataSource.setBaseDN(element3.getAttributeValue(DN));
        lDAPDataSource.setFilter(element3.getAttributeValue(FILTER));
        String string2 = element3.getAttributeValue(SCOPE);
        if (string2 != null) {
            lDAPDataSource.setScope(string2);
        }
        lDAPDataSource.setPort(Integer.parseInt(element3.getAttributeValue(PORT)));
        lDAPDataSource.setTimeOut(Integer.parseInt(element3.getAttributeValue(TIMEOUT)));
        lDAPDataSource.setBatchSize(Integer.parseInt(element3.getAttributeValue(BATCHSIZE)));
        lDAPDataSource.setAuthenticationType(element3.getAttributeValue(AUTHENTICATIONTYPE));
        lDAPDataSource.setPrinciple(element3.getAttributeValue(PRINCIPLE));
        lDAPDataSource.setCredentials(element3.getAttributeValue(CREDENTIALS));
        lDAPDataSource.setProtocol(element3.getAttributeValue(PROTOCOL));
        lDAPDataSource.setSecurity(this.loadSecurity(element));
        return lDAPDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof LDAPDataSource)) {
            throw new IllegalArgumentException("Not a LDAPDataSource");
        }
        LDAPDataSource lDAPDataSource = (LDAPDataSource)iDataSource;
        Element element = this.defineDataSource(lDAPDataSource);
        LDAPDefinition.saveSchema(lDAPDataSource.getSchema(), element);
        Element element2 = new Element("ldap", NS_DATASOURCE);
        LDAPDefinition.setAttribute(element2, LOCATION, lDAPDataSource.getLocation());
        LDAPDefinition.setAttribute(element2, DN, lDAPDataSource.getBaseDN());
        LDAPDefinition.setAttribute(element2, FILTER, lDAPDataSource.getFilter());
        LDAPDefinition.setAttribute(element2, SCOPE, lDAPDataSource.getScope());
        LDAPDefinition.setAttribute(element2, PORT, lDAPDataSource.getPort());
        LDAPDefinition.setAttribute(element2, TIMEOUT, lDAPDataSource.getTimeOut());
        LDAPDefinition.setAttribute(element2, BATCHSIZE, lDAPDataSource.getBatchSize());
        LDAPDefinition.setAttribute(element2, AUTHENTICATIONTYPE, lDAPDataSource.getAuthenticationType());
        LDAPDefinition.setAttribute(element2, PRINCIPLE, lDAPDataSource.getPrinciple());
        LDAPDefinition.setAttribute(element2, CREDENTIALS, lDAPDataSource.getCredentials());
        LDAPDefinition.setAttribute(element2, PROTOCOL, lDAPDataSource.getProtocol());
        this.saveSecurity(lDAPDataSource.getSecurity(), element);
        element.addContent(element2);
        return element;
    }
}

