/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.mongodb;

import ambience.api.MongoDBConnectionPools;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Holder;
import com.elixirtech.arch.Holder$;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data.BsonUtils$;
import com.elixirtech.data.DataConfig$;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.datasource.mongodb.MongoDBDataRecordIterator;
import com.elixirtech.data2.datasource.mongodb.MongoDBDataSource$;
import com.elixirtech.data2.iterator.IDataRecordIterable;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import com.elixirtech.mongodb.RichMongoDatabase;
import java.io.Serializable;
import java.util.Date;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.FindObservable;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class MongoDBDataSource
extends FileBasedDataSource
implements IDataRecordIterable {
    private final Holder<String> m_Name = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Description = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Pool = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Collection = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Query = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Sort = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Projection = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<DataSchema> m_Schema = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());

    public static String Type() {
        return MongoDBDataSource$.MODULE$.Type();
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        Class<T> clazz = cls;
        Class<IDataRecordIterable> clazz2 = IDataRecordIterable.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return cls.cast(this);
        }
        return super.getAdapter(cls);
    }

    @Override
    public String getName() {
        return this.m_Name.value();
    }

    @Override
    public String getDescription() {
        return this.m_Description.value();
    }

    public String getPool() {
        return this.m_Pool.value();
    }

    public String getCollection() {
        return this.m_Collection.value();
    }

    public String getQuery() {
        return this.m_Query.value();
    }

    public String getSort() {
        return this.m_Sort.value();
    }

    public String getProjection() {
        return this.m_Projection.value();
    }

    public void setName(String name) {
        this.update(this.m_Name, name);
    }

    public void setDescription(String desc) {
        this.update(this.m_Description, desc);
    }

    public void setSchema(DataSchema schema) {
        this.update(this.m_Schema, schema);
    }

    public void setPool(String pool) {
        this.update(this.m_Pool, pool);
    }

    public void setCollection(String c) {
        this.update(this.m_Collection, c);
    }

    public void setQuery(String q) {
        this.update(this.m_Query, q);
    }

    public void setSort(String s) {
        this.update(this.m_Sort, s);
    }

    public void setProjection(String p) {
        this.update(this.m_Projection, p);
    }

    @Override
    public String getType() {
        return MongoDBDataSource$.MODULE$.Type();
    }

    @Override
    public java.util.List<Parameter> getParameters() {
        ArgumentMap map = new ArgumentMap();
        map.extractParameters(this.m_Collection.value());
        map.extractParameters(this.m_Query.value());
        map.extractParameters(this.m_Sort.value());
        map.extractParameters(this.m_Projection.value());
        return map.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema.value();
    }

    @Override
    public IDataRecordIterator iterator(Map<String, String> parameters) {
        return new MongoDBDataRecordIterator(this, parameters);
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) throws DataException {
        block7: {
            String collection = cxt.substitute(this.m_Collection.value());
            String query = cxt.substitute(this.m_Query.value());
            String sort = cxt.substitute(this.m_Sort.value());
            String projection = cxt.substitute(this.m_Projection.value());
            None$ queryDoc = StringUtil.isEmpty(query) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)query)));
            None$ sortDoc = StringUtil.isEmpty(sort) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)sort)));
            None$ projectionDoc = StringUtil.isEmpty(projection) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)projection)));
            try {
                MongoDBConnectionPools api = (MongoDBConnectionPools)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDBConnectionPools.class));
                Option<RichMongoDatabase> option = api.getDatabase(this.m_Pool.value());
                if (option instanceof Some) {
                    RichMongoDatabase pool = (RichMongoDatabase)((Some)option).value();
                    MongoCollection cltn = pool.db().getCollection(collection, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
                    FindObservable q = (FindObservable)queryDoc.map((Function1 & Serializable)_$1 -> cltn.find((Bson)_$1, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).getOrElse(() -> MongoDBDataSource.$anonfun$2(cltn));
                    FindObservable s = (FindObservable)sortDoc.map((Function1 & Serializable)_$2 -> q.sort((Bson)_$2)).getOrElse(() -> MongoDBDataSource.$anonfun$4(q));
                    FindObservable f = (FindObservable)projectionDoc.map((Function1 & Serializable)_$3 -> s.projection((Bson)_$3)).getOrElse(() -> MongoDBDataSource.$anonfun$6(s));
                    Seq docs = (Seq)Await$.MODULE$.result((Awaitable)org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> MongoDBDataSource.$anonfun$7(f)).toFuture(), (Duration)DataConfig$.MODULE$.MongoTimeout());
                    dl.startData(this);
                    try {
                        docs.foreach((Function1 & Serializable)doc -> dl.processRecord(this.buildRecord((Document)doc)));
                        break block7;
                    }
                    finally {
                        dl.endData(this);
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    throw new DataException("Can't get MongoDB pool connection: " + this.m_Pool.value());
                }
                throw new MatchError(option);
            }
            catch (Exception ex) {
                throw new DataException("Can't read from MongoDB: " + ex, ex);
            }
        }
    }

    public DataRecord buildRecord(Document doc) {
        DataSchema schema = this.m_Schema.value();
        int len = schema.getColumnCount();
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.buildValue(doc, schema.getColumn(i));
        }
        return new DataRecord(schema, array);
    }

    private Object buildValue(Document doc, SchemaItem si) {
        Option option = doc.get(si.name, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bv = (BsonValue)((Some)option).value();
            return this.bsonToObject(bv, si.type);
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    private Object bsonToObject(BsonValue bv, DataType dt) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)bv, (Object)dt);
        if (tuple2 != null) {
            BsonValue bsonValue = (BsonValue)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bsonValue instanceof BsonNull) {
                BsonNull s = (BsonNull)bsonValue;
                return null;
            }
            if (bsonValue instanceof BsonUndefined) {
                BsonUndefined s = (BsonUndefined)bsonValue;
                return null;
            }
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                DataType dataType2 = DataType.STRING;
                DataType dataType3 = dataType;
                if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                    return s.getValue();
                }
            }
            if (bsonValue instanceof BsonObjectId) {
                BsonObjectId s = (BsonObjectId)bsonValue;
                DataType dataType4 = DataType.STRING;
                DataType dataType5 = dataType;
                if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                    return s.getValue().toHexString();
                }
            }
            if (bsonValue instanceof BsonNumber) {
                BsonNumber bsonNumber;
                BsonNumber s = bsonNumber = (BsonNumber)bsonValue;
                DataType dataType6 = DataType.LONG;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    return BoxesRunTime.boxToLong((long)s.longValue());
                }
                BsonNumber s2 = bsonNumber;
                DataType dataType8 = DataType.DOUBLE;
                DataType dataType9 = dataType;
                if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                    return BoxesRunTime.boxToDouble((double)s2.doubleValue());
                }
                BsonNumber s3 = bsonNumber;
                DataType dataType10 = DataType.DECIMAL;
                DataType dataType11 = dataType;
                if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                    return s3.decimal128Value().bigDecimalValue();
                }
            }
            if (bsonValue instanceof BsonBoolean) {
                BsonBoolean s = (BsonBoolean)bsonValue;
                DataType dataType12 = DataType.BOOLEAN;
                DataType dataType13 = dataType;
                if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                    return BoxesRunTime.boxToBoolean((boolean)s.getValue());
                }
            }
            if (bsonValue instanceof BsonDateTime) {
                BsonDateTime bsonDateTime;
                BsonDateTime s = bsonDateTime = (BsonDateTime)bsonValue;
                DataType dataType14 = DataType.DATE;
                DataType dataType15 = dataType;
                if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                    return new Date(s.getValue());
                }
                BsonDateTime s4 = bsonDateTime;
                DataType dataType16 = DataType.TIME;
                DataType dataType17 = dataType;
                if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                    return new Date(s4.getValue());
                }
                BsonDateTime s5 = bsonDateTime;
                DataType dataType18 = DataType.TIMESTAMP;
                DataType dataType19 = dataType;
                if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null)) {
                    return new Date(s5.getValue());
                }
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary s = (BsonBinary)bsonValue;
                DataType dataType20 = DataType.BYTE_ARRAY;
                DataType dataType21 = dataType;
                if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                    return s.getData();
                }
            }
            DataType dataType22 = DataType.STRING;
            DataType dataType23 = dataType;
            if (!(dataType22 != null ? !dataType22.equals(dataType23) : dataType23 != null)) {
                return BsonUtils$.MODULE$.asJson(bv);
            }
            return BsonUtils$.MODULE$.asString(bv);
        }
        throw new MatchError((Object)tuple2);
    }

    private DataType bsonToDataType(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonString) {
            BsonString s = (BsonString)bsonValue;
            return DataType.STRING;
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 s = (BsonInt32)bsonValue;
            return DataType.LONG;
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 s = (BsonInt64)bsonValue;
            return DataType.LONG;
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble s = (BsonDouble)bsonValue;
            return DataType.DOUBLE;
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 s = (BsonDecimal128)bsonValue;
            return DataType.DECIMAL;
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean s = (BsonBoolean)bsonValue;
            return DataType.BOOLEAN;
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray s = (BsonArray)bsonValue;
            return DataType.STRING;
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument s = (BsonDocument)bsonValue;
            return DataType.STRING;
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime s = (BsonDateTime)bsonValue;
            return DataType.TIMESTAMP;
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary s = (BsonBinary)bsonValue;
            return DataType.BYTE_ARRAY;
        }
        if (bsonValue instanceof BsonNull) {
            BsonNull s = (BsonNull)bsonValue;
            return DataType.UNKNOWN;
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId s = (BsonObjectId)bsonValue;
            return DataType.STRING;
        }
        return DataType.UNKNOWN;
    }

    public DataSchema inferSchema(PushContext cxt) throws DataException {
        DataSchema dataSchema;
        String query = cxt.substitute(this.m_Query.value());
        String sort = cxt.substitute(this.m_Sort.value());
        String projection = cxt.substitute(this.m_Projection.value());
        None$ queryDoc = StringUtil.isEmpty(query) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)query)));
        None$ sortDoc = StringUtil.isEmpty(sort) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)sort)));
        None$ projectionDoc = StringUtil.isEmpty(projection) ? None$.MODULE$ : Some$.MODULE$.apply((Object)Document$.MODULE$.apply(BsonDocument.parse((String)projection)));
        try {
            MongoDBConnectionPools api = (MongoDBConnectionPools)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDBConnectionPools.class));
            Option<RichMongoDatabase> option = api.getDatabase(this.m_Pool.value());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new DataException("Can't get MongoDB pool connection: " + this.m_Pool.value());
                }
                throw new MatchError(option);
            }
            RichMongoDatabase pool = (RichMongoDatabase)((Some)option).value();
            MongoCollection cltn = pool.db().getCollection(this.m_Collection.value(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
            FindObservable q = (FindObservable)queryDoc.map((Function1 & Serializable)_$4 -> cltn.find((Bson)_$4, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).getOrElse(() -> MongoDBDataSource.$anonfun$9(cltn));
            FindObservable s = (FindObservable)sortDoc.map((Function1 & Serializable)_$5 -> q.sort((Bson)_$5)).getOrElse(() -> MongoDBDataSource.$anonfun$11(q));
            FindObservable f = (FindObservable)projectionDoc.map((Function1 & Serializable)_$6 -> s.projection((Bson)_$6)).getOrElse(() -> MongoDBDataSource.$anonfun$13(s));
            Seq docs = (Seq)Await$.MODULE$.result((Awaitable)org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> MongoDBDataSource.$anonfun$14(f)).toFuture(), (Duration)DataConfig$.MODULE$.MongoTimeout());
            List items = (List)docs.headOption().map((Function1 & Serializable)doc -> ((IterableOnceOps)doc.map((Function1 & Serializable)pair -> new SchemaItem((String)pair._1(), this.bsonToDataType((BsonValue)pair._2())))).toList()).getOrElse(MongoDBDataSource::$anonfun$16);
            SchemaBuilder sb = new SchemaBuilder(true);
            ((List)items.sortBy((Function1 & Serializable)_$7 -> _$7.name, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)item -> sb.add((SchemaItem)item));
            dataSchema = sb.getSchema();
        }
        catch (Exception ex) {
            throw new DataException("Can't read URL: " + ex, ex);
        }
        return dataSchema;
    }

    private <T> boolean changed(Holder<T> o1, T o2) {
        if (!o1.isDefined()) {
            return o2 != null;
        }
        return !o1.equals(o2);
    }

    private <T> void update(Holder<T> o1, T o2) {
        if (this.changed(o1, o2)) {
            o1.set(o2);
            this.setDirty(true);
            return;
        }
    }

    private static final FindObservable $anonfun$2(MongoCollection cltn$2) {
        return cltn$2.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final FindObservable $anonfun$4(FindObservable q$2) {
        return q$2;
    }

    private static final FindObservable $anonfun$6(FindObservable s$2) {
        return s$2;
    }

    private static final Observable $anonfun$7(FindObservable f$1) {
        return f$1;
    }

    private static final FindObservable $anonfun$9(MongoCollection cltn$4) {
        return cltn$4.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final FindObservable $anonfun$11(FindObservable q$4) {
        return q$4;
    }

    private static final FindObservable $anonfun$13(FindObservable s$4) {
        return s$4;
    }

    private static final Observable $anonfun$14(FindObservable f$2) {
        return f$2.limit(1);
    }

    private static final List $anonfun$16() {
        return package$.MODULE$.Nil();
    }
}

