/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.object;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class JavaScriptGenerator {
    private String m_DataHolder;
    private String m_DataClass;
    private String[] m_MethodSigs;
    private String m_DataAccessMethod = "";
    private DataSchema m_Schema;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JavaScriptGenerator.class);

    public void setDataClass(String string) {
        this.m_DataClass = string;
    }

    public void setDataHolder(String string) {
        this.m_DataHolder = string;
    }

    public void setDataAccessMethod(String string) {
        this.m_DataAccessMethod = string;
    }

    public String generate() {
        this.inferSchema();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("function pushTo(cxt,dl)\n{\n").append("dl.startData(this);\n");
            stringBuilder.append(this.genIteratorCode());
            stringBuilder.append("dl.endData(this);\n");
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            m_Log.error((Object)("Generate error: " + String.valueOf(exception)));
            return null;
        }
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    private void inferSchema() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(this.m_DataClass);
            Method[] methodArray = clazz.getMethods();
            SchemaBuilder schemaBuilder = new SchemaBuilder(true);
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (method.getReturnType() == Void.TYPE || method.getParameterTypes().length > 0) continue;
                arrayList.add(method.getName());
                schemaBuilder.add(JavaScriptGenerator.guessFieldName(method.getName()), JavaScriptGenerator.getDataType(method.getReturnType()), new DataAttributes());
            }
            this.m_Schema = schemaBuilder.getSchema();
            this.m_MethodSigs = new String[arrayList.size()];
            arrayList.toArray(this.m_MethodSigs);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't infer schema: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    private static String guessFieldName(String string) {
        String string2 = string.replaceFirst("^get([A-Z])", "$1");
        return string2.replaceFirst("^is([A-Z])", "$1");
    }

    private static DataType getDataType(Class<?> clazz) {
        String string = clazz.getName();
        if (string.equals("java.lang.Integer")) {
            return DataType.LONG;
        }
        if (string.equals("java.lang.Boolean")) {
            return DataType.BOOLEAN;
        }
        if (string.equals("java.lang.Float")) {
            return DataType.DOUBLE;
        }
        if (string.equals("java.lang.Double")) {
            return DataType.DOUBLE;
        }
        if (string.equals("java.lang.Long")) {
            return DataType.LONG;
        }
        if (string.equals("java.lang.Short")) {
            return DataType.LONG;
        }
        if (string.equals("java.lang.Character")) {
            return DataType.STRING;
        }
        if (string.equals("java.lang.Byte")) {
            return DataType.LONG;
        }
        return DataType.getInstance(string);
    }

    private String genIteratorCode() throws Exception {
        String string = this.m_DataHolder.substring(this.m_DataHolder.lastIndexOf(46) + 1);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName(this.m_DataHolder, false, classLoader);
        Method method = clazz.getMethod(this.m_DataAccessMethod, new Class[0]);
        Class<?> clazz2 = method.getReturnType();
        boolean bl = Modifier.isStatic(method.getModifiers());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("importClass(Packages." + this.m_DataHolder + ");\n");
        if (bl) {
            stringBuilder.append("var dIter = " + string + "." + this.m_DataAccessMethod + "();\n");
        } else {
            stringBuilder.append("var dIter =new " + string + "()." + this.m_DataAccessMethod + "();\n");
        }
        String string2 = null;
        if (Enumeration.class.isAssignableFrom(clazz2)) {
            stringBuilder.append("while (dIter.hasMoreElements())\n");
            string2 = "dIter.nextElement()";
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            stringBuilder.append("dIter = dIter.iterator();\n");
            stringBuilder.append("while (dIter.hasNext())\n");
            string2 = "dIter.next()";
        } else if (Iterator.class.isAssignableFrom(clazz2)) {
            stringBuilder.append("while (dIter.hasNext())\n");
            string2 = "dIter.next()";
        }
        stringBuilder.append("{\n");
        stringBuilder.append("\trec = this.newRecordInstance();\n");
        stringBuilder.append("\tdata = rec.getData();\n");
        stringBuilder.append("\tdataObj = " + string2 + ";\n");
        for (int i = 0; i < this.m_MethodSigs.length; ++i) {
            stringBuilder.append(" data[" + i + "] = dataObj." + this.m_MethodSigs[i] + "();\n");
        }
        stringBuilder.append("\tdl.processRecord(rec);\n");
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

