/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.sql;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.data2.datasource.processor.sql.ConnectorNode;
import com.elixirtech.data2.datasource.processor.sql.SQLNode;
import com.elixirtech.data2.datasource.processor.sql.SQLProcessor;
import com.elixirtech.js.JavaScriptEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.mozilla.javascript.Scriptable;

public class SQLDataListener
implements DataListener {
    private final SQLProcessor m_Processor;
    private final SQLNode m_Node;
    private final PushContext m_Context;
    private final DataListener m_Next;
    private String m_StartData;
    private String m_StartGroup;
    private String m_ProcessRecord;
    private String m_EndGroup;
    private String m_EndData;
    private RecordScope m_Scope;
    private Connection m_Connection;
    private Statement m_Statement;
    private PushContext m_Substitution;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SQLDataListener.class);

    public SQLDataListener(SQLProcessor sQLProcessor, PushContext pushContext, DataListener dataListener) {
        this.m_Processor = sQLProcessor;
        this.m_Node = (SQLNode)this.m_Processor.getProcessorNode();
        this.m_Context = pushContext;
        this.m_Substitution = pushContext;
        this.m_Next = dataListener;
        this.m_StartData = this.m_Node.getStartData();
        this.m_StartGroup = this.m_Node.getStartGroup();
        this.m_ProcessRecord = this.m_Node.getProcessRecord();
        this.m_EndGroup = this.m_Node.getEndGroup();
        this.m_EndData = this.m_Node.getEndData();
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Scope = new RecordScope(iDataSource.getSchema());
        ConnectorNode connectorNode = this.m_Node.getConnectorNode();
        JDBCConnector jDBCConnector = connectorNode.getConnector(this.m_Context);
        try {
            this.m_Connection = jDBCConnector.getConnection(this.m_Context);
            this.m_Statement = this.m_Connection.createStatement();
            this.execute("startData", this.m_StartData);
            this.m_Next.startData(this.m_Processor);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error in startData: " + String.valueOf(sQLException), sQLException);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        try {
            this.execute("startGroup", this.m_StartGroup);
            this.m_Next.startGroup(dataGroup);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error in startGroup: " + String.valueOf(sQLException), sQLException);
        }
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        try {
            if (StringUtil.notEmpty(this.m_ProcessRecord)) {
                JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
                this.m_Scope.setData(dataRecord.getData());
                javaScriptEngine.pushScope((Scriptable)this.m_Scope);
                this.m_Substitution = this.m_Context.subContext(this.m_Scope.getSubstitutionMap());
                try {
                    this.execute("processRecord", this.m_ProcessRecord);
                }
                finally {
                    javaScriptEngine.popScope();
                    this.m_Substitution = this.m_Context;
                }
            }
            return this.m_Next.processRecord(dataRecord);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error in processRecord: " + String.valueOf(sQLException), sQLException);
        }
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        try {
            this.execute("endGroup", this.m_EndGroup);
            this.m_Next.endGroup(dataGroup);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error in endGroup: " + String.valueOf(sQLException), sQLException);
        }
    }

    @Override
    public void endData(IDataSource iDataSource) {
        try {
            this.execute("endData", this.m_EndData);
            this.m_Next.endData(this.m_Processor);
            this.m_Statement.close();
            this.m_Connection.close();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error in endData: " + String.valueOf(sQLException), sQLException);
        }
    }

    private void execute(String string, String string2) throws SQLException {
        if (StringUtil.notEmpty(string2)) {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            String string3 = string;
            try {
                String string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if ((string4 = string4.trim()).length() == 0 || string4.startsWith("##")) continue;
                    if (string4.startsWith("#")) {
                        this.execBuffer(string3, stringBuilder);
                        string3 = string4.substring(1).trim();
                        continue;
                    }
                    stringBuilder.append(this.m_Substitution.substitute(string4));
                    stringBuilder.append('\n');
                }
                this.execBuffer(string3, stringBuilder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void execBuffer(String string, StringBuilder stringBuilder) throws SQLException {
        if (stringBuilder.length() > 0) {
            try {
                String string2 = stringBuilder.toString();
                if (m_Log.isDebugEnabled()) {
                    m_Log.debug((Object)(string + ": " + string2));
                }
                this.m_Statement.executeUpdate(stringBuilder.toString());
            }
            catch (SQLException sQLException) {
                m_Log.error((Object)("Can't execute sql (#" + string + "): " + String.valueOf(sQLException)));
                throw sQLException;
            }
            stringBuilder.setLength(0);
        }
    }
}

