/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.sql;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.sql.SQLDataListener;
import com.elixirtech.data2.datasource.processor.sql.SQLNode;
import com.elixirtech.jdom.Element;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SQLProcessor
extends BasicProcessor {
    private SQLNode m_Node;

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("sql", Data2Constants.NS_DATASOURCE);
        this.m_Node = new SQLNode();
        this.m_Node.setStartData(this.getScript(element2, "start-data"));
        this.m_Node.setStartGroup(this.getScript(element2, "start-group"));
        this.m_Node.setProcessRecord(this.getScript(element2, "process-record"));
        this.m_Node.setEndGroup(this.getScript(element2, "end-group"));
        this.m_Node.setEndData(this.getScript(element2, "end-data"));
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("sql", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            this.setScript(element2, "start-data", this.m_Node.getStartData());
            this.setScript(element2, "start-group", this.m_Node.getStartGroup());
            this.setScript(element2, "process-record", this.m_Node.getProcessRecord());
            this.setScript(element2, "end-group", this.m_Node.getEndGroup());
            this.setScript(element2, "end-data", this.m_Node.getEndData());
        }
        element.addContent(element2);
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (SQLNode)processorNode;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        return "SQL";
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.m_Node != null) {
            ArgumentMap argumentMap = new ArgumentMap();
            argumentMap.extractParameters(this.m_Node.getStartData());
            argumentMap.extractParameters(this.m_Node.getStartGroup());
            argumentMap.extractParameters(this.m_Node.getProcessRecord());
            argumentMap.extractParameters(this.m_Node.getEndGroup());
            argumentMap.extractParameters(this.m_Node.getEndData());
            return argumentMap.getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public DataSchema getSchema() {
        return this.getInputSchema();
    }

    @Override
    public String getType() {
        return "SQL";
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        SQLDataListener sQLDataListener = new SQLDataListener(this, pushContext, dataListener);
        this.m_Parent.pushTo(pushContext, sQLDataListener);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_Owner);
        }
        return null;
    }

    private String getScript(Element element, String string) {
        Element element2 = element.getChild(string, Data2Constants.NS_DATASOURCE);
        if (element2 == null) {
            return null;
        }
        return element2.getTextNormalize();
    }

    private void setScript(Element element, String string, String string2) {
        if (StringUtil.notEmpty(string2)) {
            Element element2 = new Element(string, Data2Constants.NS_DATASOURCE);
            element2.setText(string2);
            element.addContent(element2);
        }
    }
}

