/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.trim;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.trim.TrimNode;
import com.elixirtech.jdom.Element;
import com.elixirtech.util.BitSetIterator;
import java.io.IOException;
import java.util.BitSet;

public class TrimProcessor
extends BasicProcessor {
    private TrimNode m_Node;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TrimProcessor.class);

    @Override
    public String getName() {
        return "Trim";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "Trim";
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_Parent.pushTo(pushContext, new Trimmer(dataListener));
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        this.m_Node = new TrimNode();
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (TrimNode)processorNode;
    }

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    public TrimNode getTrimNode() {
        return this.m_Node;
    }

    private class Trimmer
    implements DataListener2 {
        private DataListener m_DataListener;
        private BitSet m_Strings;

        public Trimmer(DataListener dataListener) {
            this.m_DataListener = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IAdaptable.class) {
                return clazz.cast(this);
            }
            if (clazz == IDataSource.class) {
                return clazz.cast(TrimProcessor.this.getOwner());
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.m_Strings = new BitSet();
            DataSchema dataSchema = iDataSource.getSchema();
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (dataSchema.getColumnType(i).getTypeId() != 2) continue;
                this.m_Strings.set(i);
            }
            this.m_DataListener.startData(TrimProcessor.this);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            Object[] objectArray = dataRecord.getData();
            BitSetIterator bitSetIterator = new BitSetIterator(this.m_Strings);
            while (bitSetIterator.hasNext()) {
                int n = bitSetIterator.next();
                String string = (String)objectArray[n];
                if (string == null) continue;
                objectArray[n] = string.trim();
            }
            return this.m_DataListener.processRecord(dataRecord);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_DataListener.endData(TrimProcessor.this);
        }
    }
}

