/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.properties;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.properties.PropertiesDataSource;
import com.elixirtech.jdom.Element;

public class PropertiesDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("properties", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load properties element");
        }
        PropertiesDataSource propertiesDataSource = new PropertiesDataSource();
        propertiesDataSource.setName(string);
        propertiesDataSource.setDescription(element.getAttributeValue("description"));
        propertiesDataSource.setSecurity(this.loadSecurity(element));
        for (Element element3 : element2.getChildren("property", NS_DATASOURCE)) {
            String string2 = element3.getAttributeValue("name");
            String string3 = element3.getAttributeValue("type");
            String string4 = element3.getAttributeValue("value");
            propertiesDataSource.addProperty(string2, DataType.getInstance(string3), string4);
        }
        return propertiesDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof PropertiesDataSource)) {
            throw new IllegalArgumentException("Not a PropertiesDataSource : " + iDataSource.getClass().getName());
        }
        PropertiesDataSource propertiesDataSource = (PropertiesDataSource)iDataSource;
        Element element = this.defineDataSource(propertiesDataSource);
        this.saveSecurity(propertiesDataSource.getSecurity(), element);
        Element element2 = new Element("properties", NS_DATASOURCE);
        int n = propertiesDataSource.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            PropertiesDataSource.Property property = propertiesDataSource.getProperty(i);
            Element element3 = new Element("property", NS_DATASOURCE);
            element3.setAttribute("name", property.name);
            element3.setAttribute("type", property.type.getTypeName());
            element3.setAttribute("value", property.value);
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

