/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.text;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.text.RegExpTextDataDefinition$;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataDefinition$;
import com.elixirtech.data2.datasource.text.TextDataSource;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RegExpTextDataDefinition
extends TextDataDefinition
implements LoggingHelper2,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RegExpTextDataDefinition.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String patternString;
    private final String startPatternString;
    private final String stopPatternString;
    private final String name;
    private int errorCount;
    private Option<Pattern> pattern;
    private Option<Pattern> startPattern;
    private Option<Pattern> stopPattern;
    private boolean matching;

    public static RegExpTextDataDefinition apply(String string, String string2, String string3) {
        return RegExpTextDataDefinition$.MODULE$.apply(string, string2, string3);
    }

    public static RegExpTextDataDefinition fromProduct(Product product) {
        return RegExpTextDataDefinition$.MODULE$.fromProduct(product);
    }

    public static RegExpTextDataDefinition unapply(RegExpTextDataDefinition regExpTextDataDefinition) {
        return RegExpTextDataDefinition$.MODULE$.unapply(regExpTextDataDefinition);
    }

    public RegExpTextDataDefinition(String patternString, String startPatternString, String stopPatternString) {
        this.patternString = patternString;
        this.startPatternString = startPatternString;
        this.stopPatternString = stopPatternString;
        this.name = "Text-RegExp";
        this.errorCount = 0;
        this.pattern = None$.MODULE$;
        this.startPattern = None$.MODULE$;
        this.stopPattern = None$.MODULE$;
        this.matching = false;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RegExpTextDataDefinition)) return false;
        RegExpTextDataDefinition regExpTextDataDefinition = (RegExpTextDataDefinition)object;
        String string = this.patternString();
        String string2 = regExpTextDataDefinition.patternString();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.startPatternString();
        String string4 = regExpTextDataDefinition.startPatternString();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.stopPatternString();
        String string6 = regExpTextDataDefinition.stopPatternString();
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RegExpTextDataDefinition;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "RegExpTextDataDefinition";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "patternString";
            }
            case 1: {
                return "startPatternString";
            }
            case 2: {
                return "stopPatternString";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String patternString() {
        return this.patternString;
    }

    public String startPatternString() {
        return this.startPatternString;
    }

    public String stopPatternString() {
        return this.stopPatternString;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TextDataDefinition cloneDefinition() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public void startParsing(PushContext cxt, TextDataSource src) {
        this.pattern = this.compile(cxt, this.patternString());
        this.startPattern = this.compile(cxt, this.startPatternString());
        this.stopPattern = this.compile(cxt, this.stopPatternString());
        this.matching = this.startPattern.isEmpty();
    }

    @Override
    public boolean parseLine(String line, DataRecord rec) {
        if (!this.matching) {
            Option<Pattern> option = this.startPattern;
            if (option instanceof Some) {
                Pattern sp2 = (Pattern)((Some)option).value();
                if (sp2.matcher(line).find()) {
                    this.matching = true;
                }
                return false;
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError(option);
        }
        Option<Pattern> option = this.stopPattern;
        if (option instanceof Some) {
            Pattern sp3 = (Pattern)((Some)option).value();
            if (sp3.matcher(line).find()) {
                this.matching = false;
                return false;
            }
            return this.processLine(line, rec);
        }
        if (None$.MODULE$.equals(option)) {
            return this.processLine(line, rec);
        }
        throw new MatchError(option);
    }

    public boolean processLine(String line, DataRecord rec) {
        Option<Pattern> option = this.pattern;
        if (option instanceof Some) {
            Pattern sp2 = (Pattern)((Some)option).value();
            Matcher matcher = sp2.matcher(line);
            if (matcher.find()) {
                DataSchema schema = rec.getSchema();
                int colCount = schema.getColumnCount();
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colCount).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    String data = matcher.group(i + 1);
                    try {
                        rec.setData(i, schema.parse(schema.getColumnType(i), data));
                    }
                    catch (Exception ex) {
                        ++this.errorCount;
                        this.log().warn(() -> RegExpTextDataDefinition.processLine$$anonfun$1$$anonfun$1(schema, i, ex), Line$.MODULE$.apply(70), FullName$.MODULE$.apply("com.elixirtech.data2.datasource.text.RegExpTextDataDefinition.processLine"));
                        rec.setData(i, null);
                    }
                });
                if (this.errorCount >= TextDataDefinition$.MODULE$.MaxErrorCount()) {
                    this.errorCount = 0;
                    throw new DataException("Too many parse errors");
                }
                return true;
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    @Override
    public void endParsing() {
        this.pattern = None$.MODULE$;
        this.startPattern = None$.MODULE$;
        this.stopPattern = None$.MODULE$;
        this.matching = false;
    }

    @Override
    public DataSchema inferSchema(Option<String> optHeader, Option<String> optLine, DataSchema previous) {
        int n;
        Option<Pattern> pattern = this.compile(new DefaultPushContext(), this.patternString());
        Option<Pattern> option = pattern;
        if (option instanceof Some) {
            Pattern sp2 = (Pattern)((Some)option).value();
            n = sp2.matcher("").groupCount();
        } else if (None$.MODULE$.equals(option)) {
            n = 0;
        } else {
            throw new MatchError(option);
        }
        int count = n;
        IndexedSeq cols = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> RegExpTextDataDefinition.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq types = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)_$1 -> RegExpTextDataDefinition.$anonfun$2(BoxesRunTime.unboxToInt((Object)_$1)));
        return new DataSchema(true, (String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), (DataType[])types.toArray(ClassTag$.MODULE$.apply(DataType.class)));
    }

    @Override
    public void extractParameters(ArgumentMap arguments) {
        arguments.extractParameters(this.patternString());
        arguments.extractParameters(this.startPatternString());
        arguments.extractParameters(this.stopPatternString());
    }

    private Option<Pattern> compile(PushContext cxt, String s) {
        if (StringUtil.notEmpty(s)) {
            return Try$.MODULE$.apply(() -> RegExpTextDataDefinition.compile$$anonfun$1(cxt, s)).toOption();
        }
        return None$.MODULE$;
    }

    public RegExpTextDataDefinition copy(String patternString, String startPatternString, String stopPatternString) {
        return new RegExpTextDataDefinition(patternString, startPatternString, stopPatternString);
    }

    public String copy$default$1() {
        return this.patternString();
    }

    public String copy$default$2() {
        return this.startPatternString();
    }

    public String copy$default$3() {
        return this.stopPatternString();
    }

    public String _1() {
        return this.patternString();
    }

    public String _2() {
        return this.startPatternString();
    }

    public String _3() {
        return this.stopPatternString();
    }

    private static final Object processLine$$anonfun$1$$anonfun$1(DataSchema schema$2, int i$1, Exception ex$1) {
        return "Unable to parse " + schema$2.getColumnName(i$1) + ": " + ex$1;
    }

    private static final /* synthetic */ String $anonfun$1(int i) {
        return "Field" + (i + 1);
    }

    private static final /* synthetic */ DataType $anonfun$2(int _$1) {
        return DataType.STRING;
    }

    private static final Pattern compile$$anonfun$1(PushContext cxt$1, String s$1) {
        return Pattern.compile(cxt$1.substitute(s$1));
    }
}

