/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xbase;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.util.FileUtil;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class XBaseDataSource
extends FileBasedDataSource {
    public static final String TYPE = "XBase";
    private String m_Name;
    private String m_Description;
    private DataSchema m_Schema;
    private String m_URL;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XBaseDataSource.class);

    public XBaseDataSource() {
        this("", new DataSchema());
    }

    public XBaseDataSource(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setName(String string) {
        if (XBaseDataSource.changed(this.m_Name, string)) {
            this.m_Name = string;
            this.setDirty(true);
        }
    }

    public void setDescription(String string) {
        if (XBaseDataSource.changed(this.m_Description, string)) {
            this.m_Description = string;
            this.setDirty(true);
        }
    }

    public void setURL(String string) {
        if (XBaseDataSource.changed(this.m_URL, string)) {
            this.m_URL = string;
            this.setDirty(true);
        }
    }

    public void setSchema(DataSchema dataSchema) {
        if (XBaseDataSource.changed(this.m_Schema, dataSchema)) {
            this.m_Schema = dataSchema;
            this.setDirty(true);
        }
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        return argumentMap.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void inferSchema() throws IOException {
        throw new RuntimeException("Not supported");
    }

    public static DataType getDataType(byte by) {
        switch (by) {
            case 67: {
                return DataType.STRING;
            }
            case 68: {
                return DataType.DATE;
            }
            case 70: {
                return DataType.DOUBLE;
            }
            case 76: {
                return DataType.BOOLEAN;
            }
            case 77: {
                return DataType.STRING;
            }
            case 78: {
                return DataType.DOUBLE;
            }
        }
        return DataType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        String string = pushContext.substitute(this.m_URL);
        InputStream inputStream = null;
        try {
            int n;
            inputStream = URLLoader.getInputStream(string);
            DBFReader dBFReader = new DBFReader(inputStream);
            int n2 = dBFReader.getFieldCount();
            DataType[] dataTypeArray = new DataType[n2];
            for (n = 0; n < n2; ++n) {
                DBFField dBFField = dBFReader.getField(n);
                dataTypeArray[n] = XBaseDataSource.getDataType(dBFField.getDataType());
            }
            n = dBFReader.getRecordCount();
            dataListener.startData(this);
            try {
                for (int i = 0; i < n; ++i) {
                    int n3;
                    Object[] objectArray = dBFReader.nextRecord();
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (objectArray[n3] == null) continue;
                        if (2 == dataTypeArray[n3].getTypeId()) {
                            objectArray[n3] = ((String)objectArray[n3]).trim();
                        }
                        DataType dataType = this.m_Schema.getColumnType(n3);
                        objectArray[n3] = this.m_Schema.narrow(dataType, objectArray[n3]);
                    }
                    n3 = dataListener.processRecord(new DataRecord(this.m_Schema, objectArray)) ? 1 : 0;
                    if (n3 != 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                m_Log.debug((Object)("Exception:" + String.valueOf(exception)));
            }
            finally {
                dataListener.endData(this);
            }
        }
        catch (Exception exception) {
            FileUtil.close(inputStream);
            throw new RuntimeException("Error reading XBase file " + string + " : " + String.valueOf(exception));
        }
    }
}

