/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xbase;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.xbase.XBaseDataSource;
import com.elixirtech.jdom.Element;

public class XBaseDefinition
extends DataSourceDefinition {
    public static final String URL = "url";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = XBaseDefinition.loadSchema(element2);
        Element element3 = element.getChild("xbase", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load xbase element");
        }
        String string2 = element3.getAttributeValue(URL);
        XBaseDataSource xBaseDataSource = new XBaseDataSource(string, dataSchema);
        xBaseDataSource.setURL(string2);
        xBaseDataSource.setDescription(element.getAttributeValue("description"));
        xBaseDataSource.setSecurity(this.loadSecurity(element));
        return xBaseDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof XBaseDataSource)) {
            throw new IllegalArgumentException("Not an XBaseDataSource");
        }
        XBaseDataSource xBaseDataSource = (XBaseDataSource)iDataSource;
        Element element = this.defineDataSource(xBaseDataSource);
        XBaseDefinition.saveSchema(xBaseDataSource.getSchema(), element);
        this.saveSecurity(xBaseDataSource.getSecurity(), element);
        Element element2 = new Element("xbase", NS_DATASOURCE);
        XBaseDefinition.setAttribute(element2, URL, xBaseDataSource.getURL());
        element.addContent(element2);
        return element;
    }
}

