/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.arch.xml.DefaultNamespaceStripper;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.xml.ColProcessor;
import com.elixirtech.data2.datasource.xml.DocumentCache;
import com.elixirtech.data2.datasource.xml.ElxNamespaceContext;
import com.elixirtech.data2.datasource.xml.IProcessor;
import com.elixirtech.data2.datasource.xml.XMLDataSource;
import com.elixirtech.edifact.Parser;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.dom.DOMXPath;
import com.elixirtech.jdom.input.SAXHandler;
import com.elixirtech.jdom.output.DOMOutputter;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DomProcessor
implements IProcessor {
    private XMLDataSource m_DataSource;
    private PushContext m_Context;
    private DataListener m_DataListener;
    private String m_RootXPath;
    private DataSchema m_Schema;
    private XMLDataSource.Column[] m_Columns;
    private String m_XML;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DomProcessor.class);

    public DomProcessor(XMLDataSource xMLDataSource, PushContext pushContext, DataListener dataListener) {
        this.m_DataSource = xMLDataSource;
        this.m_Context = pushContext;
        this.m_DataListener = dataListener;
        this.m_RootXPath = this.m_Context.substitute(this.m_DataSource.m_RootXPath);
        this.m_Columns = this.m_DataSource.m_Columns;
        this.m_Schema = this.m_DataSource.m_Schema;
    }

    public void setXML(String string) {
        this.m_XML = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RuntimeException {
        block10: {
            try {
                if (this.m_DataSource.getColumnCount() > 0) {
                    String string = this.m_Context.substitute(this.m_RootXPath);
                    m_Log.debug((Object)("root path: " + string));
                    DOMXPath dOMXPath = new DOMXPath(string);
                    String string2 = this.m_DataSource.getURL();
                    Document document = this.loadDocument();
                    ColProcessor colProcessor = new ColProcessor(this.m_Context, this.m_DataSource, 0);
                    ElxNamespaceContext elxNamespaceContext = new ElxNamespaceContext(document.getDocumentElement());
                    dOMXPath.setNamespaceContext(elxNamespaceContext);
                    colProcessor.setNamespaceContext(elxNamespaceContext);
                    Iterator iterator = dOMXPath.selectNodes(document).iterator();
                    m_Log.debug((Object)("startData: " + string2));
                    this.m_DataListener.startData(this.m_DataSource);
                    try {
                        Object[] objectArray = new Object[this.m_Columns.length];
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            colProcessor.prepare(this, node, objectArray);
                        }
                        break block10;
                    }
                    finally {
                        m_Log.debug((Object)("endData: " + string2));
                        this.m_DataListener.endData(this.m_DataSource);
                    }
                }
                try {
                    this.m_DataListener.startData(this.m_DataSource);
                }
                finally {
                    this.m_DataListener.endData(this.m_DataSource);
                }
            }
            catch (JaxenException jaxenException) {
                m_Log.error((Object)("Error configuring XPaths: " + jaxenException.toString()), (Throwable)jaxenException);
                throw new RuntimeException("Error configuring XPaths: " + jaxenException.toString(), jaxenException);
            }
        }
    }

    @Override
    public void processRecord(Object[] objectArray) throws RuntimeException {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray2);
        this.m_DataListener.processRecord(dataRecord);
    }

    protected Document loadDocument() throws RuntimeException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            if (StringUtil.notEmpty(this.m_XML)) {
                if (this.m_DataSource.isHTML()) {
                    XMLReader xMLReader = DomProcessor.newHTMLParser();
                    SAXHandler sAXHandler = new SAXHandler();
                    xMLReader.setContentHandler(new DefaultNamespaceStripper(sAXHandler));
                    xMLReader.parse(new InputSource(new StringReader(this.m_XML)));
                    DOMOutputter dOMOutputter = new DOMOutputter();
                    return dOMOutputter.output(sAXHandler.getDocument());
                }
                if (this.m_DataSource.isEDIFACT()) {
                    Parser parser = new Parser(new StringReader(this.m_XML));
                    DOMOutputter dOMOutputter = new DOMOutputter();
                    return dOMOutputter.output(parser.getDocument());
                }
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder.parse(new InputSource(new StringReader(this.m_XML)));
            }
            String string = this.m_Context.substitute(this.m_DataSource.getURL());
            InputSource inputSource = new InputSource(URLLoader.getInputStream(string));
            inputSource.setSystemId(string);
            if (this.m_DataSource.isHTML()) {
                XMLReader xMLReader = DomProcessor.newHTMLParser();
                SAXHandler sAXHandler = new SAXHandler();
                xMLReader.setContentHandler(new DefaultNamespaceStripper(sAXHandler));
                xMLReader.parse(inputSource);
                DOMOutputter dOMOutputter = new DOMOutputter();
                return dOMOutputter.output(sAXHandler.getDocument());
            }
            if (this.m_DataSource.isEDIFACT()) {
                Parser parser = new Parser(inputSource.getByteStream());
                DOMOutputter dOMOutputter = new DOMOutputter();
                return dOMOutputter.output(parser.getDocument());
            }
            Document document = DocumentCache.lookup(string);
            if (document != null) {
                return document;
            }
            m_Log.debug((Object)("Loading document: " + string));
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(inputSource);
            m_Log.debug((Object)("Loading complete: " + string));
            return document2;
        }
        catch (Exception exception) {
            m_Log.error((Object)("LoadDocument error: " + exception.toString()), (Throwable)exception);
            throw new RuntimeException("LoadDocument error: " + exception.toString(), exception);
        }
    }

    private static XMLReader newHTMLParser() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("org.ccil.cowan.tagsoup.Parser");
            return (XMLReader)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Can't instantiate org.ccil.cowan.tagsoup.Parser", exception);
        }
    }
}

