/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.StringStepper;
import java.util.ArrayList;

public class VariableSubstitution {
    private ICallback m_Callback;

    public VariableSubstitution(ICallback iCallback) {
        this.m_Callback = iCallback;
    }

    public String substitute(String string) {
        if (string.indexOf(36) < 0) {
            return string;
        }
        String[] stringArray = this.findParameters(string);
        if (stringArray.length == 0) {
            return string;
        }
        return this.buildResult(string, stringArray);
    }

    private String getSetting(String string) {
        return this.m_Callback.getValue(string);
    }

    private String[] findParameters(String string) {
        char c;
        StringStepper stringStepper = new StringStepper(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((c = stringStepper.getChar().charValue()) != '\u0000') {
            if (c == '\\') {
                stringStepper.advance();
                stringStepper.advance();
                continue;
            }
            if (c == '$') {
                stringStepper.advance();
                char c2 = stringStepper.getChar().charValue();
                if (c2 != '{') continue;
                stringStepper.advance();
                int n = stringStepper.getIndex();
                while (stringStepper.getChar().charValue() != '}') {
                    stringStepper.advance();
                    if (stringStepper.getChar().charValue() != '\\') continue;
                    stringStepper.advance();
                }
                int n2 = stringStepper.getIndex();
                arrayList.add(string.substring(n - 2, n2 + 1));
                continue;
            }
            stringStepper.advance();
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String buildResult(String string, String[] stringArray) {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].substring(2, stringArray[i].length() - 1);
            String string4 = this.getSetting(string3);
            if (string4 == null) continue;
            string2 = StringUtil.findAndReplace(string2, stringArray[i], string4);
        }
        return string2;
    }

    public static interface ICallback {
        public String getValue(String var1);
    }
}

