/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;

public class CommaSeparatedList
implements Function {
    public static final String SEPARATOR = ",";
    private StringBuilder m_Buffer = new StringBuilder();

    @Override
    public Object clone() {
        return new CommaSeparatedList();
    }

    @Override
    public String getName() {
        return "Comma Separated List";
    }

    @Override
    public void update(Object object) {
        if (this.m_Buffer.length() > 0) {
            this.m_Buffer.append(SEPARATOR);
        }
        this.m_Buffer.append(object);
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.update(objectArray[i]);
        }
    }

    @Override
    public Object getResult() {
        return this.m_Buffer.toString();
    }

    @Override
    public String getResultName(String string) {
        return "CSV(" + string + ")";
    }

    @Override
    public void reset() {
        this.m_Buffer.setLength(0);
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.STRING;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

