/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import java.util.Date;

public class DateAverage
implements Function {
    private long m_Baseline;
    private long m_Value;
    private int m_Count;

    @Override
    public Object clone() {
        return new DateAverage();
    }

    @Override
    public String getName() {
        return "DateAverage";
    }

    @Override
    public void update(Object object) {
        if (object instanceof Date) {
            if (this.m_Baseline == 0L) {
                this.m_Baseline = ((Date)object).getTime();
            } else {
                this.m_Value += ((Date)object).getTime() - this.m_Baseline;
            }
            ++this.m_Count;
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Date)) continue;
            if (this.m_Baseline == 0L) {
                this.m_Baseline = ((Date)objectArray[i]).getTime();
            } else {
                this.m_Value += ((Date)objectArray[i]).getTime() - this.m_Baseline;
            }
            ++this.m_Count;
        }
    }

    @Override
    public Object getResult() {
        return new Date(this.m_Baseline + this.m_Value / (long)this.m_Count);
    }

    @Override
    public String getResultName(String string) {
        return "DateAverage(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DATE;
    }

    @Override
    public void reset() {
        this.m_Baseline = 0L;
        this.m_Value = 0L;
        this.m_Count = 0;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

