/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.function.Function;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DecimalVariance
implements Function {
    protected List<BigDecimal> m_Data = new ArrayList<BigDecimal>();
    protected BigDecimal m_Total = BigDecimal.ZERO;

    @Override
    public Object clone() {
        return new DecimalVariance();
    }

    @Override
    public String getName() {
        return "Variance";
    }

    @Override
    public void update(Object object) {
        if (object instanceof BigDecimal) {
            this.m_Data.add((BigDecimal)object);
            this.m_Total = this.m_Total.add((BigDecimal)object);
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof BigDecimal)) continue;
            this.m_Data.add((BigDecimal)objectArray[i]);
            this.m_Total = this.m_Total.add((BigDecimal)objectArray[i]);
        }
    }

    @Override
    public Object getResult() {
        if (this.m_Data.size() < 2) {
            return null;
        }
        return this.calculateVariance();
    }

    @Override
    public String getResultName(String string) {
        return "Var(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DECIMAL;
    }

    protected BigDecimal calculateVariance() {
        int n = this.m_Data.size();
        if (n < 2) {
            return new BigDecimal(Double.NaN);
        }
        BigDecimal bigDecimal = new BigDecimal(n - 1);
        BigDecimal bigDecimal2 = this.m_Total.divide(new BigDecimal(n), DecimalHelper.MATH_CONTEXT);
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        for (BigDecimal bigDecimal4 : this.m_Data) {
            BigDecimal bigDecimal5 = bigDecimal4.subtract(bigDecimal2);
            bigDecimal3 = bigDecimal3.add(bigDecimal5.pow(2));
        }
        return bigDecimal3.divide(bigDecimal, DecimalHelper.MATH_CONTEXT);
    }

    @Override
    public void reset() {
        this.m_Data.clear();
        this.m_Total = BigDecimal.ZERO;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

