/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.RangeGrouper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class DateRangeSteps {
    private RangeGrouper m_Grouper;
    private SimpleDateFormat m_Format;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DateRangeSteps.class);

    public DateRangeSteps(RangeGrouper rangeGrouper, String string) {
        block6: {
            this.m_Format = new SimpleDateFormat("yyyy-MM-dd");
            this.m_Grouper = rangeGrouper;
            int n = string.indexOf(41);
            string = string.substring(5, n).trim();
            String[] stringArray = string.split(",");
            if (stringArray.length == 3) {
                try {
                    Date date = this.m_Format.parse(stringArray[0].trim());
                    int n2 = Integer.parseInt(stringArray[1].trim());
                    Date date2 = this.m_Format.parse(stringArray[2].trim());
                    if (n2 > 0) {
                        this.ascendingSteps(date, n2, date2);
                        break block6;
                    }
                    if (n2 < 0) {
                        this.descendingSteps(date, n2, date2);
                        break block6;
                    }
                    m_Log.warn((Object)"increment is zero");
                }
                catch (ParseException parseException) {
                    m_Log.warn((Object)("Error parsing date from " + string));
                }
            } else {
                m_Log.warn((Object)("incorrectly formed steps: " + string));
            }
        }
    }

    private void descendingSteps(Date date, int n, Date date2) {
        if (date.compareTo(date2) < 0) {
            m_Log.warn((Object)"start<end with negative increment");
        } else {
            RangeGrouper rangeGrouper = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper, DataType.DATE, ">" + this.string(date) + ":>" + this.string(date)));
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date);
            while (calendar.getTime().compareTo(date2) > 0) {
                calendar2.setTime(calendar.getTime());
                calendar2.add(6, n);
                if (calendar2.getTime().compareTo(date2) < 0) {
                    calendar2.setTime(date2);
                }
                RangeGrouper rangeGrouper2 = this.m_Grouper;
                Objects.requireNonNull(rangeGrouper2);
                this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper2, DataType.DATE, ">" + this.string(calendar2) + ":" + this.string(calendar) + ">" + this.string(calendar2)));
                calendar.setTime(calendar2.getTime());
            }
            RangeGrouper rangeGrouper3 = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper3);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper3, DataType.DATE, "<=" + this.string(date2) + ":<=" + this.string(date2)));
        }
    }

    private void ascendingSteps(Date date, int n, Date date2) {
        if (date.compareTo(date2) > 0) {
            m_Log.warn((Object)"start>end with positive increment");
        } else {
            RangeGrouper rangeGrouper = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper, DataType.DATE, "<" + this.string(date) + ":<" + this.string(date)));
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date);
            calendar2.setTime(date);
            while (calendar.getTime().compareTo(date2) < 0) {
                calendar2.add(6, n);
                if (calendar2.getTime().compareTo(date2) > 0) {
                    calendar2.setTime(date2);
                }
                String string = "<" + this.string(calendar2) + ":" + this.string(calendar) + "<" + this.string(calendar2);
                RangeGrouper rangeGrouper2 = this.m_Grouper;
                Objects.requireNonNull(rangeGrouper2);
                this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper2, DataType.DATE, string));
                calendar.setTime(calendar2.getTime());
            }
            RangeGrouper rangeGrouper3 = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper3);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper3, DataType.DATE, ">=" + this.string(date2) + ":>=" + this.string(date2)));
        }
    }

    private String string(Date date) {
        return this.m_Format.format(date);
    }

    private String string(Calendar calendar) {
        return this.m_Format.format(calendar.getTime());
    }
}

