/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.ComparatorFactory;
import com.elixirtech.data2.grouping.Grouper;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.data2.grouping.NamedGrouper;
import java.util.Comparator;

public class GroupDefinition
implements Comparator<DataRecord> {
    public static final String SORT_ASCENDING = "Ascending";
    public static final String SORT_DESCENDING = "Descending";
    public static final String SORT_ASCENDING_LEXICOGRAPHIC = "Ascending-Lexicographic";
    public static final String SORT_DESCENDING_LEXICOGRAPHIC = "Descending-Lexicographic";
    public static final String SORT_NONE = "None";
    protected final String m_Name;
    protected final String m_SortOrder;
    protected final String m_GroupOn;
    protected final String m_GroupData;
    protected final String m_DerivedFieldName;
    protected final boolean m_ShowTotals;
    protected DataType m_SourceType;
    protected DataType m_GroupType;
    protected Comparator m_SortComparator;
    protected int m_Index;
    protected Grouper m_Grouper;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GroupDefinition.class);

    public static boolean isAscending(String string) {
        return SORT_ASCENDING.equals(string) || SORT_ASCENDING_LEXICOGRAPHIC.equals(string);
    }

    public static boolean isDescending(String string) {
        return SORT_DESCENDING.equals(string) || SORT_DESCENDING_LEXICOGRAPHIC.equals(string);
    }

    public GroupDefinition(String string) {
        this(string, SORT_ASCENDING, "Each Value", null, null, true);
    }

    public GroupDefinition(String string, String string2) {
        this(string, string2, "Each Value", null, null, true);
    }

    public GroupDefinition(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null, true);
    }

    public GroupDefinition(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5, true);
    }

    public GroupDefinition(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (string3 == null) {
            throw new IllegalArgumentException("groupOn is null");
        }
        this.m_Name = string;
        this.m_SortOrder = string2;
        this.m_GroupOn = string3;
        this.m_GroupData = string4;
        this.m_DerivedFieldName = string5;
        this.m_ShowTotals = bl;
    }

    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_GroupData);
    }

    public void resolve(PushContext pushContext, DataSchema dataSchema) {
        assert (dataSchema != null);
        this.m_Index = dataSchema.getColumnIndex(this.m_Name);
        if (this.m_Index >= 0) {
            this.m_SourceType = dataSchema.getColumnType(this.m_Index);
            this.m_SortComparator = ComparatorFactory.getSortComparator(this.m_SourceType, this.m_SortOrder, this.m_GroupOn, this.m_GroupData);
            String string = pushContext != null ? pushContext.substitute(this.m_GroupData) : this.m_GroupData;
            this.m_Grouper = GrouperFactory.getInstance(pushContext, dataSchema, this.m_SourceType, this.m_GroupOn, string);
            if (this.m_Grouper != null) {
                this.m_GroupType = this.m_Grouper.getGroupType(this.m_SourceType);
            }
        } else {
            m_Log.error((Object)("Cannot resolve grouping field " + this.m_Name));
        }
    }

    public int getIndex() {
        return this.m_Index;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getSortOrder() {
        return this.m_SortOrder;
    }

    public String getGroupOn() {
        return this.m_GroupOn;
    }

    public String getGroupData() {
        return this.m_GroupData;
    }

    public String getDerivedFieldName() {
        return this.m_DerivedFieldName;
    }

    public String getGroupName(DataRecord dataRecord) {
        if (this.m_Grouper instanceof NamedGrouper) {
            Object object = dataRecord.getData(this.m_Index);
            return this.m_Name + "=" + ((NamedGrouper)this.m_Grouper).getGroupName(object, this.m_SourceType);
        }
        return this.m_Name;
    }

    public DataType getType() {
        if (this.m_Grouper != null) {
            return this.m_GroupType;
        }
        return this.m_SourceType;
    }

    public boolean needsSorting() {
        return this.m_SortComparator != null;
    }

    public boolean needsGrouping() {
        return this.m_Grouper != null;
    }

    @Override
    public int compare(DataRecord dataRecord, DataRecord dataRecord2) {
        Object object = dataRecord.getData(this.m_Index);
        Object object2 = dataRecord2.getData(this.m_Index);
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        return this.m_SortComparator.compare(object, object2);
    }

    public boolean isSameGroup(Object object, Object object2) {
        if (this.m_Grouper == null) {
            return false;
        }
        Object object3 = this.m_Grouper.getGroup(object);
        Object object4 = this.m_Grouper.getGroup(object2);
        if (object3 == null) {
            return object4 == null;
        }
        if (object4 == null) {
            return false;
        }
        return object3.equals(object4);
    }

    public Object getGroup(Object object) {
        if (this.m_Grouper == null) {
            return null;
        }
        return this.m_Grouper.getGroup(object);
    }

    public String getGroupName(Object object) {
        if (this.m_Grouper == null) {
            return null;
        }
        if (this.m_Grouper instanceof NamedGrouper) {
            return ((NamedGrouper)this.m_Grouper).getGroupName(object, this.m_SourceType);
        }
        return String.valueOf(this.m_Grouper.getGroup(object));
    }

    public boolean canMerge(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public boolean isShowTotals() {
        return this.m_ShowTotals;
    }
}

