/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.RangeGrouper;
import java.math.BigDecimal;
import java.util.Objects;

public class NumericRangeSteps {
    private RangeGrouper m_Grouper;
    private DataType m_Type;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(NumericRangeSteps.class);

    public NumericRangeSteps(RangeGrouper rangeGrouper, DataType dataType, String string) {
        this.m_Grouper = rangeGrouper;
        this.m_Type = dataType;
        int n = string.indexOf(41);
        string = string.substring(5, n).trim();
        String[] stringArray = string.split(",");
        if (stringArray.length == 3) {
            BigDecimal bigDecimal = new BigDecimal(stringArray[0]);
            BigDecimal bigDecimal2 = new BigDecimal(stringArray[1]);
            BigDecimal bigDecimal3 = new BigDecimal(stringArray[2]);
            BigDecimal bigDecimal4 = new BigDecimal(0);
            int n2 = bigDecimal2.compareTo(bigDecimal4);
            if (n2 > 0) {
                this.ascendingSteps(bigDecimal, bigDecimal2, bigDecimal3);
            } else if (n2 < 0) {
                this.descendingSteps(bigDecimal, bigDecimal2, bigDecimal3);
            } else {
                m_Log.warn((Object)"increment is zero");
            }
        } else {
            m_Log.warn((Object)("incorrectly formed steps: " + string));
        }
    }

    private void descendingSteps(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        if (bigDecimal.compareTo(bigDecimal3) < 0) {
            m_Log.warn((Object)"start<end with negative increment");
        } else {
            RangeGrouper rangeGrouper = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper, this.m_Type, ">" + bigDecimal.toPlainString() + ":>" + bigDecimal.toPlainString()));
            BigDecimal bigDecimal4 = bigDecimal;
            while (bigDecimal4.compareTo(bigDecimal3) > 0) {
                BigDecimal bigDecimal5 = bigDecimal4.add(bigDecimal2);
                if (bigDecimal5.compareTo(bigDecimal3) < 0) {
                    bigDecimal5 = bigDecimal3;
                }
                RangeGrouper rangeGrouper2 = this.m_Grouper;
                Objects.requireNonNull(rangeGrouper2);
                this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper2, this.m_Type, ">" + bigDecimal5.toPlainString() + ":" + bigDecimal4.toPlainString() + ">" + bigDecimal5.toPlainString()));
                bigDecimal4 = bigDecimal5;
            }
            RangeGrouper rangeGrouper3 = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper3);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper3, this.m_Type, "<=" + bigDecimal3.toPlainString() + ":<=" + bigDecimal3.toPlainString()));
        }
    }

    private void ascendingSteps(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        if (bigDecimal.compareTo(bigDecimal3) > 0) {
            m_Log.warn((Object)"start>end with positive increment");
        } else {
            RangeGrouper rangeGrouper = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper, this.m_Type, "<" + bigDecimal.toPlainString() + ":<" + bigDecimal.toPlainString()));
            BigDecimal bigDecimal4 = bigDecimal;
            while (bigDecimal4.compareTo(bigDecimal3) < 0) {
                BigDecimal bigDecimal5 = bigDecimal4.add(bigDecimal2);
                if (bigDecimal5.compareTo(bigDecimal3) > 0) {
                    bigDecimal5 = bigDecimal3;
                }
                RangeGrouper rangeGrouper2 = this.m_Grouper;
                Objects.requireNonNull(rangeGrouper2);
                this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper2, this.m_Type, "<" + bigDecimal5.toPlainString() + ":" + bigDecimal4.toPlainString() + "<" + bigDecimal5.toPlainString()));
                bigDecimal4 = bigDecimal5;
            }
            RangeGrouper rangeGrouper3 = this.m_Grouper;
            Objects.requireNonNull(rangeGrouper3);
            this.m_Grouper.addPart(new RangeGrouper.Part(rangeGrouper3, this.m_Type, ">=" + bigDecimal3.toPlainString() + ":>=" + bigDecimal3.toPlainString()));
        }
    }
}

