/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.DateRangeSteps;
import com.elixirtech.data2.grouping.NamedGrouper;
import com.elixirtech.data2.grouping.NumericRangeSteps;
import com.elixirtech.data2.grouping.TimeRangeSteps;
import com.elixirtech.data2.grouping.TimeStampRangeSteps;
import java.util.ArrayList;
import java.util.List;

public class RangeGrouper
implements NamedGrouper {
    public static final int LESS_THAN = 1;
    public static final int EQUAL = 2;
    public static final int GREATER_THAN = 3;
    public static final int TRUE = 4;
    public static final int FALSE = 5;
    public static final int LESS_THAN_OR_EQUAL = 6;
    public static final int GREATER_THAN_OR_EQUAL = 7;
    final DataSchema m_Schema;
    final DataType m_Type;
    private final List<Part> m_Parts = new ArrayList<Part>();
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RangeGrouper.class);

    public RangeGrouper(DataSchema dataSchema, DataType dataType, String string) {
        this.m_Schema = dataSchema;
        this.m_Type = dataType;
        if (string.startsWith("step(")) {
            this.processSteps(dataType, string);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\|")) {
                String string3 = string2.trim();
                if (string3.length() <= 1) continue;
                this.m_Parts.add(new Part(dataType, string3));
            }
        }
    }

    protected void processSteps(DataType dataType, String string) {
        if (dataType.isNumeric()) {
            new NumericRangeSteps(this, dataType, string);
        } else if (dataType == DataType.DATE) {
            new DateRangeSteps(this, string);
        } else if (dataType == DataType.TIME) {
            new TimeRangeSteps(this, string);
        } else if (dataType == DataType.TIMESTAMP) {
            new TimeStampRangeSteps(this, string);
        } else {
            m_Log.warn((Object)("step mode not supported for data type " + dataType.getTypeName()));
        }
        if (m_Log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Part part : this.m_Parts) {
                stringBuilder.append("[" + part.toString() + "] ");
            }
            m_Log.debug((Object)("Parts: " + stringBuilder.toString()));
        }
    }

    @Override
    public Object getGroup(Object object) {
        return this.getGroupName(object, this.m_Type);
    }

    @Override
    public DataType getGroupType(DataType dataType) {
        return DataType.STRING;
    }

    @Override
    public String getGroupName(Object object, DataType dataType) {
        for (Part part : this.m_Parts) {
            if (!part.matches(object)) continue;
            return part.getGroupName();
        }
        return "";
    }

    protected void addPart(Part part) {
        this.m_Parts.add(part);
    }

    protected class Part {
        private final int m_Test;
        private final Comparable m_Value;
        private final String m_GroupName;

        public Part(DataType dataType, String string) {
            String string2 = string;
            char c = string2.charAt(0);
            if (c == '<') {
                if (string2.charAt(1) == '=') {
                    this.m_Test = 6;
                    string2 = string2.substring(2);
                } else {
                    this.m_Test = 1;
                    string2 = string2.substring(1);
                }
            } else if (c == '>') {
                if (string2.charAt(1) == '=') {
                    this.m_Test = 7;
                    string2 = string2.substring(2);
                } else {
                    this.m_Test = 3;
                    string2 = string2.substring(1);
                }
            } else if (c == '=') {
                this.m_Test = 2;
                string2 = string2.substring(1);
            } else {
                this.m_Test = 4;
            }
            String string3 = "";
            int n = string2.indexOf(":");
            if (n >= 0) {
                string3 = string2.substring(0, n);
                this.m_GroupName = string2.substring(n + 1);
            } else {
                this.m_GroupName = this.m_Test == 4 ? string2 : "";
            }
            this.m_Value = this.getComparable(dataType, string3);
        }

        public Part(int n, Comparable<?> comparable, String string) {
            this.m_Test = n;
            this.m_Value = comparable;
            this.m_GroupName = string;
        }

        public boolean matches(Object object) {
            if (this.m_Test == 4) {
                return true;
            }
            if (this.m_Test == 5) {
                return false;
            }
            if (this.m_Value == null) {
                return object == null;
            }
            if (object == null) {
                return this.m_Value == null;
            }
            int n = this.m_Value.compareTo(object);
            switch (this.m_Test) {
                case 1: {
                    return n > 0;
                }
                case 3: {
                    return n < 0;
                }
                case 6: {
                    return n >= 0;
                }
                case 7: {
                    return n <= 0;
                }
                case 2: {
                    return n == 0;
                }
            }
            m_Log.warn((Object)("Unknown test code: " + this.m_Test));
            return false;
        }

        public String getGroupName() {
            return this.m_GroupName;
        }

        public String toString() {
            return this.m_GroupName;
        }

        protected Comparable getComparable(DataType dataType, String string) {
            try {
                Object object = RangeGrouper.this.m_Schema.parse(dataType, string);
                if (object == null) {
                    return null;
                }
                if (object instanceof Comparable) {
                    return (Comparable)object;
                }
                if (dataType == DataType.BOOLEAN) {
                    return new BooleanComparable((Boolean)object);
                }
                m_Log.warn((Object)(dataType.getTypeName() + " not supported"));
            }
            catch (Throwable throwable) {
                m_Log.warn((Object)("Cannot parse " + string + " as a " + dataType.getTypeName()));
            }
            return null;
        }
    }

    private static class BooleanComparable
    implements Comparable<Object> {
        private final Boolean m_Value;

        public BooleanComparable(Boolean bl) {
            this.m_Value = bl;
        }

        @Override
        public int compareTo(Object object) {
            if (this.m_Value == null) {
                return object == null ? 0 : -1;
            }
            if (object == null) {
                return this.m_Value == null ? 0 : 1;
            }
            if (this.m_Value.equals(object)) {
                return 0;
            }
            if (!this.m_Value.booleanValue()) {
                return -1;
            }
            return 1;
        }
    }
}

