/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.data2.olap.Dimension;
import com.elixirtech.data2.olap.Hierarchy;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Cube {
    private IDataSource m_DataSource;
    private DataTable m_Table;
    private DataSchema m_Schema;
    private Map<String, Hierarchy> m_Hierarchies = new TreeMap<String, Hierarchy>();
    private Set<Measure> m_Measures = new HashSet<Measure>();

    public Cube(IDataSource iDataSource) {
        this.m_DataSource = iDataSource;
        this.m_Schema = iDataSource.getSchema();
    }

    public Cube(DataTable dataTable) {
        this.m_DataSource = dataTable;
        this.m_Table = dataTable;
        this.m_Schema = dataTable.getSchema();
    }

    public IDataSource getDataSource() {
        return this.m_DataSource;
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public IDimension[] getHierarchies() {
        IDimension[] iDimensionArray = new IDimension[this.m_Hierarchies.size()];
        this.m_Hierarchies.values().toArray(iDimensionArray);
        return iDimensionArray;
    }

    public IDimension getHierarchy(String string) {
        return this.m_Hierarchies.get(string);
    }

    public Iterator<Hierarchy> getHierarchyIterator() {
        return this.m_Hierarchies.values().iterator();
    }

    public DataRecord[] getRecords(PushContext pushContext) throws DataException {
        if (this.m_Table == null) {
            this.buildTable(pushContext);
        }
        return this.m_Table.getRecords();
    }

    public IDimension createHierarchy(String string, Level[] levelArray) {
        if (this.m_Hierarchies.containsKey(string)) {
            throw new IllegalArgumentException("Hierarchy " + string + " already defined");
        }
        if (this.m_Schema.getColumnIndex(string) >= 0) {
            throw new IllegalArgumentException(string + " is a schema name, so it can't be used for a hierarchy");
        }
        Hierarchy hierarchy = new Hierarchy(string);
        for (int i = 0; i < levelArray.length; ++i) {
            hierarchy.addLevel(levelArray[i]);
        }
        this.m_Hierarchies.put(string, hierarchy);
        return hierarchy;
    }

    public IDimension createDimension(Level level) {
        Dimension dimension = new Dimension(level);
        return dimension;
    }

    public boolean hasHierarchy(String string) {
        return this.m_Hierarchies.containsKey(string);
    }

    public IDimension createDimension(String string, String string2, String string3, String string4, String string5, boolean bl) {
        Level level = this.createLevel(string, string2, string3, string4, string5, bl);
        return new Dimension(level);
    }

    public IDimension createDimension(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        Level level = this.createLevel(string, string2, string3, string4, string5, string6, bl);
        return new Dimension(level);
    }

    public Level createLevel(String string) {
        return new Level(string, "Ascending", "Each Value", null, null, true);
    }

    public Level createLevel(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return new Level(string, string2, string3, string4, string5, bl);
    }

    public Level createLevel(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        return new Level(string, string2, string3, string4, string5, string6, bl);
    }

    public Measure createMeasure(String string, Function function, String string2) {
        int n = this.m_Schema.getColumnIndex(string);
        if (n < 0) {
            throw new RuntimeException("Measure " + string + " not available");
        }
        Measure measure = new Measure(string, n, function, string2);
        this.m_Measures.add(measure);
        if (this.m_Table != null && function instanceof RangedFunction) {
            this.buildRangedMeasure(measure);
        }
        return measure;
    }

    public void removeMeasure(Measure measure) {
        this.m_Measures.remove(measure);
    }

    public int getMeasureCount() {
        return this.m_Measures.size();
    }

    public Iterator<Measure> getMeasureIterator() {
        return this.m_Measures.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("olap.Cube(");
        Iterator<Hierarchy> iterator = this.m_Hierarchies.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(",");
        Iterator<Measure> iterator2 = this.m_Measures.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append(iterator2.next());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected DataRecord[] buildTable(PushContext pushContext) throws DataException {
        this.m_Table = null;
        this.m_Table = DataTable.build(pushContext, this.m_DataSource);
        this.buildRangedMeasures();
        if (this.m_Table != null) {
            return this.m_Table.getRecords();
        }
        return null;
    }

    protected void buildRangedMeasures() throws DataException {
        for (Measure measure : this.m_Measures) {
            if (!(measure.getFunction() instanceof RangedFunction)) continue;
            this.buildRangedMeasure(measure);
        }
    }

    protected void buildRangedMeasure(Measure measure) {
        RangedFunction rangedFunction = (RangedFunction)measure.getFunction();
        int n = measure.getIndex();
        if (n < 0) {
            throw new RuntimeException("Measure " + measure.getName() + " not available");
        }
        this.m_Table.setRange(rangedFunction, this.m_Table.getGroups(), n);
    }
}

