/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.GroupDefinition;
import com.elixirtech.data2.olap.AllDataSet;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.DataSet;
import com.elixirtech.data2.olap.DataSetFactory;
import com.elixirtech.data2.olap.DataSets;
import com.elixirtech.data2.olap.Dimension;
import com.elixirtech.data2.olap.HierarchyDataSet;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.SafeComparable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CubeData {
    private Cube m_Cube;
    private DataSchema m_Schema;
    private PushContext m_PushContext;
    private DataRecord[] m_Records;
    private HashMap<IDimension, DataSets> m_DataSets = new HashMap();

    public CubeData(Cube cube) {
        this.m_Cube = cube;
    }

    public void initRecords(PushContext pushContext) throws DataException {
        this.m_PushContext = pushContext;
        try {
            this.m_DataSets.clear();
            this.m_Records = new DataRecord[0];
            this.m_Records = this.m_Cube.buildTable(this.m_PushContext);
        }
        catch (DataException dataException) {
            this.m_Records = new DataRecord[0];
            throw dataException;
        }
        finally {
            this.m_Schema = this.m_Cube.getSchema();
        }
    }

    public DataRecord[] getRecords() {
        return this.m_Records;
    }

    public IDataSet getAllDataSet() {
        int n = this.m_Records != null ? this.m_Records.length : 0;
        return new AllDataSet(n);
    }

    public DataSets getDataSets(IDimension iDimension) {
        return this.m_DataSets.get(iDimension);
    }

    public DataSets buildDataSets(IDimension iDimension) {
        if (this.m_Schema == null) {
            throw new IllegalStateException("schema is null");
        }
        DataSets dataSets = this.m_DataSets.get(iDimension);
        if (dataSets == null) {
            dataSets = iDimension instanceof Dimension ? this.buildDimension(iDimension) : this.buildHierarchy(iDimension);
        }
        return dataSets;
    }

    private Map<Object, IDataSet> buildNamedSets(Level level, DataSetFactory dataSetFactory) {
        level.resolve(this.m_PushContext, this.m_Schema);
        HashMap<Object, IDataSet> hashMap = new HashMap<Object, IDataSet>();
        LinkedHashMap<Object, IDataSet> linkedHashMap = new LinkedHashMap<Object, IDataSet>();
        int n = level.getIndex();
        if (this.m_Records != null) {
            for (int i = 0; i < this.m_Records.length; ++i) {
                Object object = this.m_Records[i].getData(n);
                Object object2 = level.getGroup(object);
                IDataSet iDataSet = (IDataSet)hashMap.get(object2);
                if (iDataSet != null) {
                    iDataSet.add(i);
                    continue;
                }
                String string = level.getGroupName(object);
                iDataSet = dataSetFactory.create(level, object2, string);
                iDataSet.add(i);
                hashMap.put(object2, iDataSet);
                linkedHashMap.put(new SafeComparable((Comparable)object2), iDataSet);
            }
        }
        return linkedHashMap;
    }

    private DataSets buildDimension(IDimension iDimension) {
        Level level = iDimension.getLevel(0);
        Map<Object, IDataSet> map = this.buildNamedSets(level, new DataSet.Factory());
        Comparator<IDataSet> comparator = null;
        String string = level.getSortOrder();
        if (GroupDefinition.isAscending(string)) {
            comparator = DataSets.ASCENDING;
        } else if (GroupDefinition.isDescending(string)) {
            comparator = DataSets.DESCENDING;
        }
        DataSets dataSets = new DataSets(iDimension, map, comparator);
        this.m_DataSets.put(iDimension, dataSets);
        return dataSets;
    }

    private DataSets buildHierarchy(IDimension iDimension) {
        int n = iDimension.getLevelCount();
        Level level = iDimension.getLevel(n - 1);
        Map<Object, IDataSet> map = this.buildNamedSets(level, new HierarchyDataSet.Factory());
        ArrayList<IDataSet> arrayList = new ArrayList<IDataSet>();
        arrayList.addAll(map.values());
        int n2 = arrayList.size();
        for (int i = n - 2; i >= 0; --i) {
            Object object;
            level = iDimension.getLevel(i);
            level.resolve(this.m_PushContext, this.m_Schema);
            HashMap<Object, HierarchyDataSet> hashMap = new HashMap<Object, HierarchyDataSet>();
            map.clear();
            for (int j = 0; j < n2; ++j) {
                object = (HierarchyDataSet)arrayList.get(j);
                Index index = ((HierarchyDataSet)object).getIndex();
                if (index.isEmpty()) continue;
                int n3 = index.getFirst();
                Object object2 = level.getGroup(this.m_Records[n3]);
                HierarchyDataSet hierarchyDataSet = (HierarchyDataSet)hashMap.get(object2);
                if (hierarchyDataSet == null) {
                    String string = level.getGroupName(this.m_Records[n3]);
                    hierarchyDataSet = new HierarchyDataSet(level, object2, string);
                    hashMap.put(object2, hierarchyDataSet);
                    map.put(string, hierarchyDataSet);
                }
                hierarchyDataSet.addChild((HierarchyDataSet)object);
            }
            Comparator<IDataSet> comparator = null;
            object = level.getSortOrder();
            if (GroupDefinition.isAscending((String)object)) {
                comparator = DataSets.ASCENDING;
            } else if (GroupDefinition.isDescending((String)object)) {
                comparator = DataSets.DESCENDING;
            }
            if (comparator != null) {
                for (HierarchyDataSet hierarchyDataSet : hashMap.values()) {
                    hierarchyDataSet.sort(comparator);
                }
            }
            arrayList.clear();
            arrayList.addAll(hashMap.values());
            n2 = arrayList.size();
        }
        DataSets dataSets = new DataSets(iDimension, map, DataSets.ASCENDING);
        this.m_DataSets.put(iDimension, dataSets);
        return dataSets;
    }
}

