/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.NestedFunction;
import com.elixirtech.data2.olap.AllDataSet;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeData;
import com.elixirtech.data2.olap.CubeGrouping;
import com.elixirtech.data2.olap.CubeGroupingOptions;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CubeDataSource
extends AbstractDataSource {
    private final String m_Name;
    private final Cube m_Cube;
    private final IDimension[] m_Rows;
    private final IDimension[] m_Columns;
    private final Measure[] m_Measures;
    private String m_Description;
    private DataSchema m_Schema;
    private boolean m_CollapseRows;
    private boolean m_CollapseColumns;
    private boolean m_KeepRowTotals;
    private boolean m_KeepColumnTotals;
    private String m_ColumnTitle = "All";
    private String m_RowTitle = "All";
    private CubeGrouping m_RowGrouping;
    private List<TreeNode> m_RowLeaves;
    private CubeGrouping m_ColumnGrouping;
    private List<TreeNode> m_ColumnLeaves;
    private int m_ReEntrantCount;
    private DataRecord[] m_Records;
    private boolean m_KeepRecords;
    private boolean m_RowTotalsAfter = true;
    private boolean m_ColumnTotalsAfter = true;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CubeDataSource.class);

    public CubeDataSource(String string, Cube cube, IDimension[] iDimensionArray, IDimension[] iDimensionArray2, Measure[] measureArray) {
        int n;
        for (n = 0; n < iDimensionArray.length; ++n) {
            assert (iDimensionArray[n] != null) : "Null row: " + n;
        }
        for (n = 0; n < iDimensionArray2.length; ++n) {
            assert (iDimensionArray2[n] != null) : "Null column: " + n;
        }
        this.m_Name = string;
        this.m_Cube = cube;
        this.m_Rows = iDimensionArray;
        this.m_Columns = iDimensionArray2;
        this.m_Measures = measureArray;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return "Cube";
    }

    public Cube getCube() {
        return this.m_Cube;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setCollapseRows(boolean bl) {
        this.m_CollapseRows = bl;
    }

    public boolean isCollapseRows() {
        return this.m_CollapseRows;
    }

    public void setCollapseColumns(boolean bl) {
        this.m_CollapseColumns = bl;
    }

    public boolean isCollapseColumns() {
        return this.m_CollapseColumns;
    }

    public void setKeepRowTotals(boolean bl) {
        this.m_KeepRowTotals = bl;
    }

    public boolean isKeepRowTotals() {
        return this.m_KeepRowTotals;
    }

    public void setKeepColumnTotals(boolean bl) {
        this.m_KeepColumnTotals = bl;
    }

    public boolean isKeepColumnTotals() {
        return this.m_KeepColumnTotals;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.m_Cube.getDataSource().getParameters();
    }

    public IDataSource getParent() {
        return this.m_Cube.getDataSource();
    }

    public void setColumnTitle(String string) {
        if (string != null) {
            this.m_ColumnTitle = string;
        }
    }

    public String getColumnTitle() {
        return this.m_ColumnTitle;
    }

    public void setRowTitle(String string) {
        if (string != null) {
            this.m_RowTitle = string;
        }
    }

    public String getRowTitle() {
        return this.m_RowTitle;
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
    }

    public DataSchema getCachedSchema() {
        return this.m_Schema;
    }

    @Override
    public synchronized DataSchema getSchema() {
        if (this.m_Schema == null) {
            this.init(null);
        }
        return this.m_Schema;
    }

    public DataSchema getSourceSchema() {
        return this.m_Cube.getSchema();
    }

    public IDimension[] getHierarchies() {
        return this.m_Cube.getHierarchies();
    }

    public Measure[] getMeasures() {
        return this.m_Measures;
    }

    public IDimension[] getRows() {
        return this.m_Rows;
    }

    public IDimension[] getColumns() {
        return this.m_Columns;
    }

    public boolean isKeepRecords() {
        return this.m_KeepRecords;
    }

    public void setKeepRecords(boolean bl) {
        this.m_KeepRecords = bl;
    }

    public DataRecord[] getRecords() {
        assert (this.m_KeepRecords);
        return this.m_Records;
    }

    public void setRowTotalsAfter(boolean bl) {
        this.m_RowTotalsAfter = bl;
    }

    public void setColumnTotalsAfter(boolean bl) {
        this.m_ColumnTotalsAfter = bl;
    }

    @Override
    public synchronized void pushTo(PushContext pushContext, DataListener dataListener) {
        ++this.m_ReEntrantCount;
        this.init(pushContext);
        m_Log.info((Object)"Starting to provide records");
        dataListener.startData(this);
        for (TreeNode treeNode : this.m_RowLeaves) {
            this.processRows(pushContext, treeNode, dataListener, false);
        }
        dataListener.endData(this);
        m_Log.info((Object)"All records complete");
        --this.m_ReEntrantCount;
        if (this.m_ReEntrantCount == 0 && !this.m_KeepRecords) {
            this.m_Records = null;
        }
    }

    public synchronized CubeGrouping getRowGrouping(PushContext pushContext) {
        if (this.m_RowGrouping == null) {
            m_Log.info((Object)"Init called from getRowGrouping");
            this.init(pushContext);
        }
        return this.m_RowGrouping;
    }

    public synchronized CubeGrouping getColumnGrouping(PushContext pushContext) {
        if (this.m_ColumnGrouping == null) {
            m_Log.info((Object)"Init called from getColumnGrouping");
            this.init(pushContext);
        }
        return this.m_ColumnGrouping;
    }

    private void init(PushContext pushContext) {
        int n;
        m_Log.info((Object)"Cube initialization");
        PushContext pushContext2 = pushContext == null ? new DefaultPushContext() : pushContext;
        CubeData cubeData = new CubeData(this.m_Cube);
        try {
            cubeData.initRecords(pushContext2);
            this.m_Records = cubeData.getRecords();
        }
        catch (DataException dataException) {
            m_Log.error((Object)"Can't get cube records", (Throwable)dataException);
            this.m_Records = new DataRecord[0];
        }
        m_Log.info((Object)"Building datasets");
        for (n = 0; n < this.m_Rows.length; ++n) {
            cubeData.buildDataSets(this.m_Rows[n]);
        }
        for (n = 0; n < this.m_Columns.length; ++n) {
            cubeData.buildDataSets(this.m_Columns[n]);
        }
        m_Log.info((Object)"Defining groupings");
        CubeGroupingOptions cubeGroupingOptions = CubeGroupingOptions.build().setKeepTotals(this.m_KeepRowTotals).setRemoveEmpty(this.m_CollapseRows).options();
        this.m_RowGrouping = new CubeGrouping(cubeData, this.m_Rows, cubeGroupingOptions);
        this.m_RowGrouping.setTitle(this.m_RowTitle);
        this.m_RowLeaves = this.m_RowGrouping.getAugmentedLeafNodes(this.m_RowTotalsAfter);
        CubeGroupingOptions cubeGroupingOptions2 = CubeGroupingOptions.build().setKeepTotals(this.m_KeepColumnTotals).setRemoveEmpty(this.m_CollapseColumns).options();
        this.m_ColumnGrouping = new CubeGrouping(cubeData, this.m_Columns, cubeGroupingOptions2);
        this.m_ColumnGrouping.setTitle(this.m_ColumnTitle);
        this.m_ColumnLeaves = this.m_ColumnGrouping.getAugmentedLeafNodes(this.m_ColumnTotalsAfter);
        m_Log.info((Object)"Building schema");
        try {
            this.buildSchema(pushContext2);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("Can't get build schema: " + String.valueOf(dataException)), (Throwable)dataException);
        }
    }

    private void buildSchema(PushContext pushContext) throws DataException {
        int n = this.m_RowGrouping.getLevelCount();
        List<TreeNode> list = this.m_ColumnGrouping.getAugmentedLeafNodes(this.m_ColumnTotalsAfter);
        int n2 = list.size();
        int n3 = n + n2 * this.m_Measures.length;
        String[] stringArray = new String[n3];
        DataType[] dataTypeArray = new DataType[n3];
        for (int i = 0; i < n; ++i) {
            Level level = this.m_RowGrouping.getLevel(i);
            stringArray[i] = level.getName();
            dataTypeArray[i] = level.getType();
        }
        VarSubCallback varSubCallback = new VarSubCallback(pushContext);
        for (int i = 0; i < n2; ++i) {
            String string = this.getColumnName(list.get(i));
            DataSchema dataSchema = this.m_Cube.getSchema();
            for (int j = 0; j < this.m_Measures.length; ++j) {
                int n4 = n + i * this.m_Measures.length + j;
                Measure measure = this.m_Measures[j];
                stringArray[n4] = this.buildColumnName(varSubCallback, string, measure);
                int n5 = measure.getIndex();
                if (n5 < 0) {
                    throw new DataException("Measure " + measure.getName() + " not available");
                }
                dataTypeArray[n4] = measure.getResultType(dataSchema.getColumnType(n5));
            }
        }
        this.m_Schema = new DataSchema(true, stringArray, dataTypeArray);
    }

    private String getColumnName(TreeNode treeNode) {
        TreeNode[] treeNodeArray = treeNode.getPath();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < treeNodeArray.length; ++i) {
            stringBuilder.append(treeNodeArray[i].getName());
            if (i >= treeNodeArray.length - 1) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private String buildColumnName(VarSubCallback varSubCallback, String string, Measure measure) {
        String string2 = measure.getColumnNamePattern();
        if (StringUtil.isEmpty(string2)) {
            return string + "/" + measure.getResultName();
        }
        String string3 = StringUtil.isEmpty(string) ? this.m_ColumnTitle : string;
        String[] stringArray = string3.split("/");
        varSubCallback.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            varSubCallback.put(String.valueOf(i), stringArray[i]);
        }
        String string4 = measure.getResultName();
        varSubCallback.put("hierarchy", string3);
        varSubCallback.put("field", measure.getName());
        varSubCallback.put("measure", string4);
        varSubCallback.put("fn", measure.getFunction().getName());
        varSubCallback.put("*", string3 + "/" + string4);
        return ArgumentMap.substitute(string2, varSubCallback);
    }

    private boolean processRows(PushContext pushContext, TreeNode treeNode, DataListener dataListener, boolean bl) {
        Index index = treeNode.getTreeIndex();
        if (this.m_CollapseRows && index.isEmpty()) {
            return true;
        }
        DataRecord dataRecord = this.buildRecord(treeNode.getPath(), index);
        pushContext.throb();
        return dataListener.processRecord(dataRecord);
    }

    private DataRecord buildRecord(TreeNode[] treeNodeArray, Index index) {
        int n;
        int n2 = this.m_RowGrouping.getLevelCount();
        int n3 = this.m_ColumnLeaves.size();
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        for (n = 0; n < treeNodeArray.length - 1; ++n) {
            objectArray[n] = treeNodeArray[n + 1].getDataSet().getKey();
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < this.m_Measures.length; ++i) {
                TreeNode treeNode = this.m_ColumnLeaves.get(n);
                Index index2 = treeNode.getTreeIndex();
                Index index3 = index.intersection(index2);
                Function function = this.m_Measures[i].getFunction();
                int n4 = this.m_Measures[i].getIndex();
                if (function instanceof NestedFunction) {
                    Index index4;
                    Object[] objectArray2;
                    if (treeNodeArray.length > 1) {
                        objectArray2 = treeNodeArray[treeNodeArray.length - 2].getTreeIndex();
                        index4 = objectArray2.intersection(index2);
                    } else {
                        index4 = new AllDataSet(this.m_Records.length);
                    }
                    objectArray2 = ((Index)index4).collect(this.m_Records, this.m_Measures[i].getIndex());
                    ((NestedFunction)function).setRange(objectArray2);
                }
                index3.apply(function, this.m_Records, n4);
                objectArray[n2 + n * this.m_Measures.length + i] = function.getResult();
                function.reset();
            }
        }
        return new DataRecord(this.m_Schema, objectArray);
    }

    private static class VarSubCallback
    implements ArgumentMap.ICallback {
        private PushContext m_Context;
        private Map<String, String> m_Map = new HashMap<String, String>();

        public VarSubCallback(PushContext pushContext) {
            this.m_Context = pushContext;
        }

        @Override
        public String getValue(String string, String string2) {
            String string3 = this.m_Map.get(string);
            if (string3 != null) {
                return string3;
            }
            return this.m_Context.getParameter(string);
        }

        public void clear() {
            this.m_Map.clear();
        }

        public void put(String string, String string2) {
            this.m_Map.put(string, string2);
        }
    }
}

