/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.olap.DataSetFactory;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DataSet
implements IDataSet {
    private final Level m_Level;
    private final Object m_Key;
    private final String m_Name;
    private final Index m_Index = new Index();
    private Map<Measure, Object> m_MeasureValues = new HashMap<Measure, Object>();

    public DataSet(Level level, Object object, String string) {
        this.m_Level = level;
        this.m_Key = object;
        this.m_Name = string;
    }

    @Override
    public Level getLevel() {
        return this.m_Level;
    }

    @Override
    public Object getKey() {
        return this.m_Key;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void add(int n) {
        this.m_Index.add(n);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("\tSet " + String.valueOf(this.m_Key) + " : " + String.valueOf(this.m_Index));
    }

    @Override
    public Index getIndex() {
        return this.m_Index;
    }

    @Override
    public TreeNode buildTreeNode(TreeNode treeNode, Index index) {
        return new TreeNode(treeNode, this, index);
    }

    public void buildMeasure(DataRecord[] dataRecordArray, Measure measure) throws DataException {
        Function function = measure.getFunction();
        int n = measure.getIndex();
        if (n < 0) {
            throw new DataException("Measure " + measure.getName() + " not available");
        }
        this.m_MeasureValues.put(measure, this.m_Index.getResult(function, dataRecordArray, n));
    }

    @Override
    public void apply(Function function, DataRecord[] dataRecordArray, int n) {
        this.m_Index.apply(function, dataRecordArray, n);
    }

    public static class Factory
    implements DataSetFactory {
        @Override
        public IDataSet create(Level level, Object object, String string) {
            return new DataSet(level, object, string);
        }
    }
}

