/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.NullGroup;
import com.elixirtech.data2.olap.DataSet;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.IDimension;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public class DataSets {
    private IDimension m_Key;
    private Map<Object, IDataSet> m_DataSets;
    private IDataSet[] m_DataSetArray;
    public static final Comparator<IDataSet> ASCENDING = new AscendingComparator();
    public static final Comparator<IDataSet> DESCENDING = new DescendingComparator();

    public DataSets(IDimension iDimension, Map<Object, IDataSet> map, Comparator<IDataSet> comparator) {
        this.m_Key = iDimension;
        this.m_DataSets = map;
        this.m_DataSetArray = new IDataSet[this.m_DataSets.size()];
        this.m_DataSets.values().toArray(this.m_DataSetArray);
        if (comparator != null) {
            Arrays.sort(this.m_DataSetArray, comparator);
        }
    }

    public DataSet getDataSet(Object object) {
        return (DataSet)this.m_DataSets.get(object);
    }

    public int getDataSetCount() {
        return this.m_DataSetArray.length;
    }

    public IDataSet getDataSet(int n) {
        return this.m_DataSetArray[n];
    }

    public IDataSet[] getDataSets() {
        return this.m_DataSetArray;
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("DataSets " + String.valueOf(this.m_Key));
        Iterator<IDataSet> iterator = this.m_DataSets.values().iterator();
        while (iterator.hasNext()) {
            ((DataSet)iterator.next()).dump(printWriter);
        }
        printWriter.println();
    }

    protected static final boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        return object == NullGroup.INSTANCE;
    }

    private static class AscendingComparator
    implements Comparator<IDataSet> {
        private AscendingComparator() {
        }

        @Override
        public int compare(IDataSet iDataSet, IDataSet iDataSet2) {
            Comparable comparable = (Comparable)iDataSet.getKey();
            Comparable comparable2 = (Comparable)iDataSet2.getKey();
            if (DataSets.isNull(comparable)) {
                return DataSets.isNull(comparable2) ? 0 : -1;
            }
            if (DataSets.isNull(comparable2)) {
                return 1;
            }
            return comparable.compareTo(comparable2);
        }
    }

    private static class DescendingComparator
    implements Comparator<IDataSet> {
        private DescendingComparator() {
        }

        @Override
        public int compare(IDataSet iDataSet, IDataSet iDataSet2) {
            Comparable comparable = (Comparable)iDataSet.getKey();
            Comparable comparable2 = (Comparable)iDataSet2.getKey();
            if (DataSets.isNull(comparable2)) {
                return DataSets.isNull(comparable) ? 0 : -1;
            }
            if (DataSets.isNull(comparable)) {
                return 1;
            }
            return comparable2.compareTo(comparable);
        }
    }
}

