/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.olap.DataSetFactory;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HierarchyDataSet
implements IDataSet,
Comparable<HierarchyDataSet> {
    private final Level m_Level;
    private final Object m_Key;
    private final String m_Name;
    private Index m_Index = new Index();
    private Map<Measure, Object> m_MeasureValues = new HashMap<Measure, Object>();
    private HierarchyDataSet m_Parent;
    private List<IDataSet> m_Children;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HierarchyDataSet.class);

    public HierarchyDataSet(Level level, Object object, String string) {
        this.m_Level = level;
        this.m_Key = object;
        this.m_Name = string;
    }

    @Override
    public int compareTo(HierarchyDataSet hierarchyDataSet) {
        try {
            return ((Comparable)this.m_Key).compareTo(hierarchyDataSet.m_Key);
        }
        catch (Exception exception) {
            m_Log.debug((Object)("error in compareTo: " + String.valueOf(exception)));
            return 0;
        }
    }

    @Override
    public Level getLevel() {
        return this.m_Level;
    }

    @Override
    public Object getKey() {
        return this.m_Key;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void add(int n) {
        this.m_Index.add(n);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("\tSet " + String.valueOf(this.m_Key) + " : " + String.valueOf(this.m_Index));
    }

    @Override
    public Index getIndex() {
        return this.m_Index;
    }

    @Override
    public TreeNode buildTreeNode(TreeNode treeNode, Index index) {
        TreeNode treeNode2 = new TreeNode(treeNode, this, index);
        if (this.m_Children != null) {
            for (IDataSet iDataSet : this.m_Children) {
                Index index2 = index.intersection(iDataSet.getIndex());
                ((HierarchyDataSet)iDataSet).buildTreeNode(treeNode2, index2);
            }
        }
        return treeNode2;
    }

    public void buildMeasure(DataRecord[] dataRecordArray, Measure measure) throws DataException {
        Function function = measure.getFunction();
        int n = measure.getIndex();
        if (n < 0) {
            throw new DataException("Measure " + measure.getName() + " not available");
        }
        this.m_MeasureValues.put(measure, this.m_Index.getResult(function, dataRecordArray, n));
    }

    @Override
    public void apply(Function function, DataRecord[] dataRecordArray, int n) {
        this.m_Index.apply(function, dataRecordArray, n);
    }

    public void setParent(HierarchyDataSet hierarchyDataSet) {
        this.m_Parent = hierarchyDataSet;
    }

    public HierarchyDataSet getParent() {
        return this.m_Parent;
    }

    public void addChild(HierarchyDataSet hierarchyDataSet) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList<IDataSet>();
        }
        this.m_Children.add(hierarchyDataSet);
        hierarchyDataSet.setParent(this);
        this.m_Index = this.m_Index.union(hierarchyDataSet.getIndex());
    }

    public void sort(Comparator<? super IDataSet> comparator) {
        if (this.m_Children != null) {
            Collections.sort(this.m_Children, comparator);
        }
    }

    public static class Factory
    implements DataSetFactory {
        @Override
        public IDataSet create(Level level, Object object, String string) {
            return new HierarchyDataSet(level, object, string);
        }
    }
}

