/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import ambience.api.JDBCConnectionPools;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.output.BaseJDBCDataStore;
import com.elixirtech.data2.output.DSWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class JDBCConnectionPoolStore
extends BaseJDBCDataStore {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCConnectionPoolStore.class);
    private String m_Path;

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        return argumentMap.getParameters();
    }

    @Override
    public ElxLoggerJ getLog() {
        return m_Log;
    }

    @Override
    protected Connection openConnection() {
        try {
            this.m_Connection = ((JDBCConnectionPools)Elixir.get(JDBCConnectionPools.class)).getConnectionJ(this.m_Path);
            if (!this.m_AutoCommit) {
                this.m_Connection.setAutoCommit(false);
            }
            return this.m_Connection;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Connection Pool Store unable to open connection, SQLException:" + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    public String getFileURL() {
        return this.m_Path;
    }

    public void setFileURL(String string) {
        this.m_Path = string;
    }
}

