/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.output.BaseJDBCDataStore;
import com.elixirtech.data2.output.DSWrapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

public class JDBCDataStore
extends BaseJDBCDataStore {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCDataStore.class);
    private static final boolean m_Debug = m_Log.isDebugEnabled();
    private String m_URL;
    private String m_User;
    private String m_Password;

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        argumentMap.extractParameters(this.m_User);
        argumentMap.extractParameters(this.m_Password);
        return argumentMap.getParameters();
    }

    public String getDriver() {
        return this.m_Driver;
    }

    public void setDriver(String string) {
        this.m_Driver = string;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public void setPassword(String string) {
        this.m_Password = string;
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setUser(String string) {
        this.m_User = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDBCDataStore)) {
            return false;
        }
        JDBCDataStore jDBCDataStore = (JDBCDataStore)object;
        return JDBCDataStore.equal(this.m_Driver, jDBCDataStore.m_Driver) && JDBCDataStore.equal(this.m_URL, jDBCDataStore.m_URL);
    }

    private static boolean equal(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    protected Connection openConnection() {
        Object object;
        try {
            object = Thread.currentThread().getContextClassLoader();
            Class.forName(this.m_Context.substitute(this.m_Driver), true, (ClassLoader)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Driver not found: " + this.m_Driver, exception);
        }
        try {
            object = this.m_Context.substitute(this.m_URL);
            String string = this.m_Context.substitute(this.m_User);
            String string2 = this.m_Context.substitute(this.m_Password);
            this.m_Connection = DriverManager.getConnection((String)object, string, string2);
            if (m_Debug) {
                this.printConnectionInfo("Connection information ", false);
            }
            if (!this.m_AutoCommit) {
                this.m_Connection.setAutoCommit(false);
                if (m_Debug) {
                    this.printConnectionInfo("Set auto commit off ", false);
                }
            }
            return this.m_Connection;
        }
        catch (Exception exception) {
            this.printConnectionInfo("Open connection Error ", true);
            throw new RuntimeException("Open connection error: " + String.valueOf(exception), exception);
        }
    }

    private void printConnectionInfo(String string, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.m_Connection != null) {
                DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
                stringBuilder.append("Driver name: " + databaseMetaData.getDriverName());
                stringBuilder.append(", Database product name: " + databaseMetaData.getDatabaseProductName());
                stringBuilder.append(", version :" + databaseMetaData.getDatabaseProductVersion());
                stringBuilder.append(", User: " + databaseMetaData.getUserName());
                stringBuilder.append(", URL: " + databaseMetaData.getURL());
                stringBuilder.append(", Auto-commit: " + this.m_Connection.getAutoCommit());
            }
            if (bl) {
                m_Log.error((Object)(string + "; " + stringBuilder.toString()));
            } else {
                m_Log.debug((Object)(string + "; " + stringBuilder.toString()));
            }
        }
        catch (SQLException sQLException) {
            m_Log.error((Object)"Unable to extract connection information");
        }
    }

    @Override
    public ElxLoggerJ getLog() {
        return m_Log;
    }
}

