/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.OutputHandler;
import com.elixirtech.js.JavaScriptEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Scriptable;

public class TextDataStore
implements IDataStore2 {
    private static AtomicInteger m_SerialIds = new AtomicInteger(0);
    private int m_Serial = m_SerialIds.incrementAndGet();
    private String m_Name;
    private DataStore m_DataStore;
    private PushContext m_Context;
    private String m_Filename;
    private boolean m_Append;
    private String m_LineSeparator = System.getProperty("line.separator");
    private String m_URLString;
    private PrintWriter m_Writer;
    private RecordScope m_Scope;
    private Script m_StartData;
    private Script m_StartGroup;
    private Script m_Record;
    private Script m_EndGroup;
    private Script m_EndData;
    private boolean m_IsStartData = false;
    private boolean m_IsStartGroup = false;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TextDataStore.class);

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_Filename);
        argumentMap.extractParameters(this.m_StartData.code);
        argumentMap.extractParameters(this.m_StartGroup.code);
        argumentMap.extractParameters(this.m_Record.code);
        argumentMap.extractParameters(this.m_EndGroup.code);
        argumentMap.extractParameters(this.m_EndData.code);
        return argumentMap.getParameters();
    }

    public void setFilename(String string) {
        this.m_Filename = string;
    }

    public void setAppend(boolean bl) {
        this.m_Append = bl;
    }

    public void setStartData(String string) {
        this.m_StartData = new Script("startData", string);
    }

    public void setStartGroup(String string) {
        this.m_StartGroup = new Script("startGroup", string);
    }

    public void setProcessRecord(String string) {
        this.m_Record = new Script("processRecord", string);
    }

    public void setEndGroup(String string) {
        this.m_EndGroup = new Script("endGroup", string);
    }

    public void setEndData(String string) {
        this.m_EndData = new Script("endData", string);
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_URLString = this.m_Context.substitute(this.m_Filename);
        Object object = this.m_URLString;
        if (!OutputHandler.hasExtension((String)object)) {
            object = (String)object + ".txt";
        }
        try {
            OutputStream outputStream = OutputHandler.getOutputStream((String)object, this.m_Append);
            String string = "[" + this.m_Serial + "] Opening " + this.m_URLString + " for output (append=" + this.m_Append + ")";
            m_Log.info((Object)string);
            JobLogging.logInfo("TextDataStore", string);
            this.m_Writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error opening url \"" + (String)object + "\" : " + String.valueOf(iOException), iOException);
        }
        this.m_Scope = new RecordScope(iDataSource.getSchema());
        this.m_Scope.setContext(this.m_Context);
        this.m_IsStartData = true;
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        this.m_IsStartGroup = true;
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        this.m_Scope.setData(dataRecord.getData());
        if (this.m_IsStartData) {
            this.m_IsStartData = false;
            this.process(this.m_StartData);
        }
        if (this.m_IsStartGroup) {
            this.m_IsStartGroup = false;
            this.process(this.m_StartGroup);
        }
        this.process(this.m_Record);
        return this.m_Context != null ? !this.m_Context.isAborted() : true;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        this.process(this.m_EndGroup);
    }

    @Override
    public void endData(IDataSource iDataSource) {
        this.process(this.m_EndData);
        String string = "[" + this.m_Serial + "] Closing " + this.m_URLString;
        m_Log.info((Object)string);
        JobLogging.logInfo("TextDataStore", string);
        this.m_Writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Script script) {
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.pushScope((Scriptable)this.m_Scope);
        try {
            String string = this.m_Context.substitute(script.code);
            string = StringUtil.findAndReplace(string, "\n", this.m_LineSeparator);
            this.m_Writer.print(string);
        }
        finally {
            javaScriptEngine.popScope();
        }
    }

    private static class Script {
        public String src;
        public String code;

        public Script(String string, String string2) {
            this.src = string;
            this.code = string2;
        }
    }
}

