/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output.sql;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataType;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.util.FileUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Dialect {
    private static final String FILENAME = "jdbc-dialects.xml";
    public static final String TABLE_OPTIONS = "tableOptions";
    public static final String BATCH_SIZE = "batchSize";
    private static final String[] ALL = new String[]{"tableOptions", "batchSize"};
    private String m_Name;
    private String m_Extends;
    private Map<String, String> m_Attributes = new HashMap<String, String>();
    private Map<String, String> m_Types = new HashMap<String, String>();
    private Properties m_Properties = new Properties();
    private static Map<String, Dialect> m_Dialects = new HashMap<String, Dialect>();
    private static Map<String, String> m_DialectMap;
    private static String m_DefaultDialect;
    private static final ElxLoggerJ m_Log;

    public static Dialect getInstance(String string) {
        return m_Dialects.get(string);
    }

    public static String[] getNames() {
        Object[] objectArray = new String[m_Dialects.size()];
        m_Dialects.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static String[] getAttributeNames() {
        return ALL;
    }

    public static String getDriverDialect(String string) {
        if (string == null) {
            return null;
        }
        return m_DialectMap.get(string);
    }

    public static String getDefaultDialect() {
        return m_DefaultDialect;
    }

    public Dialect(String string) {
        this.m_Name = string;
        m_Dialects.put(this.m_Name, this);
    }

    public void setExtends(String string) {
        this.m_Extends = string;
    }

    public void setAttribute(String string, String string2) {
        this.m_Attributes.put(string, string2);
    }

    public String getName() {
        return this.m_Name;
    }

    public String toString() {
        return this.m_Name;
    }

    public void addType(String string, String string2) {
        this.m_Types.put(string, string2);
    }

    public String getTypeName(DataType dataType) {
        return this.getTypeName(dataType.getTypeName());
    }

    public String getTypeName(String string) {
        Dialect dialect;
        String string2 = this.m_Types.get(string);
        if (string2 == null && StringUtil.notEmpty(this.m_Extends) && (dialect = Dialect.getInstance(this.m_Extends)) != null && (string2 = dialect.getTypeName(string)) != null) {
            this.m_Types.put(string, string2);
        }
        return string2;
    }

    public String getAttribute(String string) {
        Dialect dialect;
        String string2 = this.m_Attributes.get(string);
        if (string2 == null && StringUtil.notEmpty(this.m_Extends) && (dialect = Dialect.getInstance(this.m_Extends)) != null && (string2 = dialect.getAttribute(string)) != null) {
            this.m_Attributes.put(string, string2);
        }
        return string2;
    }

    public void addProperty(String string, String string2) {
        this.m_Properties.setProperty(string, string2);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.buildProperties(properties);
        return properties;
    }

    protected void buildProperties(Properties properties) {
        Dialect dialect;
        if (StringUtil.notEmpty(this.m_Extends) && (dialect = Dialect.getInstance(this.m_Extends)) != null) {
            dialect.buildProperties(properties);
        }
        properties.putAll((Map<?, ?>)this.m_Properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDialects() {
        m_Log.info((Object)"Loading dialects");
        m_DialectMap = new HashMap<String, String>();
        m_DefaultDialect = "";
        InputStream inputStream = null;
        try {
            inputStream = Dialect.getConfigStream();
            if (inputStream != null) {
                SAXBuilder sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build(inputStream);
                Element element = document.getRootElement();
                Dialect.loadMap(element);
                Dialect.loadDialects(element);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error loading jdbc-dialects.xml: " + String.valueOf(exception)), (Throwable)exception);
        }
        finally {
            FileUtil.close(inputStream);
        }
    }

    private static void loadMap(Element element) {
        Element element2 = element.getChild("dialect-map");
        m_DefaultDialect = element2.getAttributeValue("default");
        for (Element element3 : element2.getChildren("driver")) {
            String string = element3.getAttributeValue("name");
            String string2 = element3.getAttributeValue("dialect");
            m_DialectMap.put(string, string2);
        }
    }

    private static void loadDialects(Element element) {
        for (Element element2 : element.getChildren("dialect")) {
            String string = element2.getAttributeValue("name");
            String string2 = element2.getAttributeValue("extends");
            if (string == null) continue;
            Dialect dialect = new Dialect(string);
            if (StringUtil.notEmpty(string2)) {
                dialect.setExtends(string2);
            }
            String[] stringArray = Dialect.getAttributeNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = element2.getAttributeValue(stringArray[i]);
                if (string3 == null) continue;
                dialect.setAttribute(stringArray[i], string3);
            }
            Dialect.addDataTypes(dialect, element2.getChild("datatypes"));
            Dialect.addProperties(dialect, element2.getChild("properties"));
        }
    }

    private static void addDataTypes(Dialect dialect, Element element) {
        if (element != null) {
            for (Element element2 : element.getChildren("type")) {
                String string = element2.getAttributeValue("id");
                String string2 = element2.getAttributeValue("value");
                if (string == null || string2 == null) continue;
                dialect.addType(string, string2);
            }
        }
    }

    private static void addProperties(Dialect dialect, Element element) {
        if (element != null) {
            for (Element element2 : element.getChildren("property")) {
                String string = element2.getAttributeValue("name");
                String string2 = element2.getAttributeValue("value");
                if (string == null || string2 == null) continue;
                dialect.addProperty(string, string2);
            }
        }
    }

    private static InputStream getConfigStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream("config/jdbc-dialects.xml");
    }

    static {
        m_Log = ElxLoggerJ.getLogger(Dialect.class);
        Dialect.loadDialects();
    }
}

