/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalDataType
extends DataType {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DecimalDataType.class);

    @Override
    public int getTypeId() {
        return 18;
    }

    @Override
    public String getTypeName() {
        return "Decimal";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        BigDecimal bigDecimal2 = (BigDecimal)object2;
        return bigDecimal.compareTo(bigDecimal2);
    }

    @Override
    public Object defaultValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            return new BigDecimal(String.valueOf((Number)object));
        }
        try {
            return new BigDecimal(String.valueOf(object));
        }
        catch (NumberFormatException numberFormatException) {
            m_Log.error((Object)("Cannot parse " + String.valueOf(object) + " as a Decimal"));
            return BigDecimal.ZERO;
        }
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        return 5 + byArray.length;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            BigDecimal bigDecimal = (BigDecimal)object;
            dataOutputStream.writeByte(18);
            dataOutputStream.writeInt(bigDecimal.scale());
            BigInteger bigInteger = bigDecimal.unscaledValue();
            byte[] byArray = bigInteger.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 18) {
            throw new IOException("Decimal tag expected, got " + by);
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        BigInteger bigInteger = new BigInteger(byArray);
        return new BigDecimal(bigInteger, n);
    }
}

