/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LongDataType
extends DataType {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LongDataType.class);

    @Override
    public int getTypeId() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "Long";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Object defaultValue() {
        return 0L;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Long l = (Long)object;
        Long l2 = (Long)object2;
        return l.compareTo(l2);
    }

    @Override
    public Long narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException numberFormatException) {
            m_Log.error((Object)("Cannot parse " + String.valueOf(object) + " as a Long"));
            return 0L;
        }
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 9;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            Long l = (Long)object;
            dataOutputStream.writeByte(8);
            dataOutputStream.writeLong(l);
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 8) {
            throw new IOException("Long tag expected, got " + by);
        }
        return dataInputStream.readLong();
    }
}

