/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class StringDataType
extends DataType {
    private static final int ChunkSize = 20480;

    @Override
    public int getTypeId() {
        return 2;
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return "";
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        String string = (String)object;
        String string2 = (String)object2;
        int n = string.compareTo(string2);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public String narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object, Charset.forName("UTF-8"));
        }
        return String.valueOf(object);
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 1 + this.writeLength((String)object);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            String string = (String)object;
            dataOutputStream.writeByte(2);
            this.writeUtf(dataOutputStream, string);
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 2) {
            throw new IOException("String tag expected, got " + by);
        }
        return this.readUtf(dataInputStream);
    }

    public int writeLength(String string) {
        int n = string.length();
        int n2 = n == 0 ? 0 : (n - 1) / 20480 + 1;
        switch (n2) {
            case 0: {
                return 0;
            }
        }
        return 4 * n2 + this.utf8Length(string);
    }

    private int utf8Length(String string) {
        int n = string.length();
        int n2 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public void writeUtf(DataOutputStream dataOutputStream, String string) throws IOException {
        int n = string.length();
        int n2 = n == 0 ? 0 : (n - 1) / 20480 + 1;
        dataOutputStream.writeInt(n2);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                dataOutputStream.writeUTF(string);
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    int n3 = 20480 * i;
                    int n4 = Math.min(n3 + 20480, n);
                    dataOutputStream.writeUTF(string.substring(n3, n4));
                }
            }
        }
    }

    public String readUtf(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return dataInputStream.readUTF();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dataInputStream.readUTF());
        }
        return stringBuilder.toString();
    }
}

