/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.xlsx;

import com.elixirtech.data2.xlsx.Workbook;
import java.util.Calendar;
import java.util.Date;

public abstract class Cell {
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_DATE = 2;
    public static final int TYPE_TIME = 3;
    public static final int TYPE_TIMESTAMP = 4;
    public static final int TYPE_NUMBER = 5;
    public static final int TYPE_BOOLEAN = 6;
    public static final Cell[] EMPTY_ROW = new Cell[0];

    public abstract int getType();

    public abstract String getValueString();

    protected Calendar buildCalendar(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public static class BooleanCell
    extends Cell {
        private final String m_ValueString;
        private final Boolean m_Value;

        public BooleanCell(String string) {
            this.m_ValueString = string;
            this.m_Value = "1".equals(this.m_ValueString);
        }

        @Override
        public int getType() {
            return 6;
        }

        public Boolean getValue() {
            return this.m_Value;
        }

        @Override
        public String getValueString() {
            return this.m_ValueString;
        }
    }

    public static class NumberCell
    extends Cell {
        private final String m_ValueString;

        public NumberCell(String string) {
            this.m_ValueString = string;
        }

        @Override
        public int getType() {
            return 5;
        }

        public Double getValue() {
            return Double.valueOf(this.m_ValueString);
        }

        @Override
        public String getValueString() {
            return this.m_ValueString;
        }
    }

    public static class TimestampCell
    extends Cell {
        private final String m_ValueString;
        private final Date m_Value;

        public TimestampCell(Workbook workbook, String string) {
            Calendar calendar;
            this.m_ValueString = string;
            double d = Double.parseDouble(string);
            int n = (int)Math.floor(d);
            if (workbook.uses1904Dates()) {
                calendar = this.buildCalendar(1904);
                calendar.add(6, n);
            } else {
                calendar = this.buildCalendar(1900);
                int n2 = n >= 60 ? n - 2 : n - 1;
                calendar.add(6, n2);
            }
            double d2 = d - (double)n;
            int n3 = (int)Math.round(d2 * 86400.0);
            calendar.add(13, n3);
            this.m_Value = calendar.getTime();
        }

        @Override
        public int getType() {
            return 4;
        }

        public Date getValue() {
            return this.m_Value;
        }

        @Override
        public String getValueString() {
            return this.m_ValueString;
        }
    }

    public static class TimeCell
    extends Cell {
        private final String m_ValueString;
        private final Date m_Value;

        public TimeCell(String string) {
            this.m_ValueString = string;
            double d = Double.parseDouble(string);
            double d2 = d - Math.floor(d);
            long l = (long)(d2 * 86400.0 * 1000.0);
            this.m_Value = new Date(l);
        }

        @Override
        public int getType() {
            return 3;
        }

        public Date getValue() {
            return this.m_Value;
        }

        @Override
        public String getValueString() {
            return this.m_ValueString;
        }
    }

    public static class DateCell
    extends Cell {
        private final String m_ValueString;
        private final Date m_Value;

        public DateCell(Workbook workbook, String string) {
            Calendar calendar;
            this.m_ValueString = string;
            double d = Double.parseDouble(string);
            int n = (int)Math.floor(d);
            if (workbook.uses1904Dates()) {
                calendar = this.buildCalendar(1904);
                calendar.add(6, n);
            } else {
                calendar = this.buildCalendar(1900);
                int n2 = n >= 60 ? n - 2 : n - 1;
                calendar.add(6, n2);
            }
            this.m_Value = calendar.getTime();
        }

        @Override
        public int getType() {
            return 2;
        }

        public Date getValue() {
            return this.m_Value;
        }

        @Override
        public String getValueString() {
            return this.m_ValueString;
        }
    }

    public static class TextCell
    extends Cell {
        private final String m_Value;

        public TextCell(String string) {
            this.m_Value = string;
        }

        @Override
        public int getType() {
            return 1;
        }

        public String getValue() {
            return this.m_Value;
        }

        @Override
        public String getValueString() {
            return this.m_Value;
        }
    }
}

