/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.edifact;

import java.io.IOException;
import java.io.Reader;

public class Tokenizer {
    public static final char EDIFACT_SEGMENT_TERMINATOR = '\'';
    public static final char EDIFACT_DATA_ELEMENT_SEPARATOR = '+';
    public static final char EDIFACT_COMPONENT_DATA_ELEMENT_SEPARATOR = ':';
    public static final char EDIFACT_RELEASE = '?';
    public static final int SEGMENT_TERMINATOR = 1;
    public static final int DATA_ELEMENT_SEPARATOR = 2;
    public static final int COMPONENT_DATA_ELEMENT_SEPARATOR = 3;
    public static final int START_COMPONENT = 4;
    public static final int EMPTY_VALUE = 5;
    public static final int END_COMPONENT = 6;
    public static final int DATA = 10;
    private final Reader m_Reader;
    private Token m_Next;
    private int m_Char;
    private StringBuilder m_SB = new StringBuilder();

    public Tokenizer(Reader reader) throws IOException {
        this.m_Reader = reader;
        this.advance();
        this.buildNext();
    }

    public boolean hasNext() {
        return this.m_Next != null;
    }

    public Token next() throws IOException {
        Token token = this.m_Next;
        this.buildNext();
        return token;
    }

    private void buildNext() throws IOException {
        this.m_Next = null;
        block8: while (this.m_Char != -1) {
            switch (this.m_Char) {
                case 10: {
                    this.advance();
                    continue block8;
                }
                case 13: {
                    this.advance();
                    continue block8;
                }
                case 39: {
                    if (this.m_SB.length() > 0) break block8;
                    this.m_Next = new Token(1);
                    this.advance();
                    break block8;
                }
                case 43: {
                    if (this.m_SB.length() > 0) break block8;
                    this.m_Next = new Token(2);
                    this.advance();
                    break block8;
                }
                case 58: {
                    if (this.m_SB.length() > 0) break block8;
                    this.m_Next = new Token(3);
                    this.advance();
                    break block8;
                }
                case 63: {
                    this.advance();
                    if (this.m_Char == -1) break;
                    this.m_SB.append((char)this.m_Char);
                    break;
                }
                default: {
                    this.m_SB.append((char)this.m_Char);
                }
            }
            this.advance();
        }
        if (this.m_Next == null && this.m_SB.length() > 0) {
            this.m_Next = new Token(10, this.m_SB.toString());
            this.m_SB.setLength(0);
        }
    }

    private void advance() throws IOException {
        this.m_Char = this.m_Reader.read();
    }

    public static class Token {
        public final int id;
        public final String data;

        public Token(int n) {
            this.id = n;
            this.data = null;
        }

        public Token(int n, String string) {
            this.id = n;
            this.data = string;
        }

        public String toString() {
            switch (this.id) {
                case 1: {
                    return "<seg>";
                }
                case 2: {
                    return "<,>";
                }
                case 3: {
                    return "<comp-sep>";
                }
                case 5: {
                    return "<empty>";
                }
                case 4: {
                    return "<component>";
                }
                case 6: {
                    return "</component>";
                }
                case 10: {
                    return this.data;
                }
            }
            return "ERROR UNKNOWN id (" + this.id + ")";
        }
    }
}

