/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.awt.TextBlock;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.MovingConnection;
import com.elixirtech.canvas.corego.PolylineConnectorGO;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.LabelConnection;
import java.awt.Point;

public class DataFlowGO
extends PolylineConnectorGO {
    public MovingConnection m_Label;
    public Point m_LabelPoint;
    private static final int RADIUS = 50;

    @Override
    public String getTypeName() {
        return "DataFlowGO";
    }

    @Override
    public void setStart(GO gO, Point point) {
        InOutGO inOutGO = (InOutGO)gO;
        InOutGO.Out out = inOutGO.getOut(point);
        if (out == null) {
            throw new RuntimeException("DataFlowGO.NO_OUTWARD");
        }
        this.m_Start = new LabelConnection(inOutGO, out);
        Relationship relationship = gO.connectTo(this, RelType.Repaints);
        relationship.setUserProperty("start", "true");
        this.m_Start.setPoint(point);
    }

    @Override
    public void setStop(GO gO, Point point) {
        InOutGO inOutGO = (InOutGO)gO;
        InOutGO.In in = inOutGO.getIn(point);
        if (in == null) {
            throw new RuntimeException("DataFlowGO.NO_INWARD");
        }
        this.m_Stop = new LabelConnection(inOutGO, in);
        Relationship relationship = gO.connectTo(this, RelType.Repaints);
        relationship.setUserProperty("stop", "true");
        this.m_Stop.setPoint(point);
    }

    public InOutGO.IOBase getStartIO() {
        return ((LabelConnection)this.m_Start).getIOBase();
    }

    public InOutGO.IOBase getStopIO() {
        return ((LabelConnection)this.m_Stop).getIOBase();
    }

    public void buildParameters(ArgumentMap argumentMap) {
        ((InOutGO)this.getStartGO()).buildParameters(argumentMap);
    }

    public DataSchema getSchema() {
        DataSchema dataSchema = ((InOutGO)this.getStartGO()).getSchema();
        if (dataSchema == null) {
            System.out.println("DataFlowGO has null schema from " + String.valueOf(this.getStartGO()));
        }
        return dataSchema;
    }

    @Override
    protected void buildInwardEdgeConnector(Relationship relationship) {
        if (relationship.getRelType() == RelType.Repaints) {
            if (relationship.getUserProperty("start") != null) {
                InOutGO inOutGO = (InOutGO)relationship.getOrigin();
                InOutGO.Out out = inOutGO.getOut(this.m_Points[0]);
                this.m_Start = new LabelConnection(inOutGO, out);
                this.m_Start.setPoint(this.m_Points[0]);
            } else if (relationship.getUserProperty("stop") != null) {
                InOutGO inOutGO = (InOutGO)relationship.getOrigin();
                InOutGO.In in = inOutGO.getIn(this.m_Points[this.m_Points.length - 1]);
                this.m_Stop = new LabelConnection(inOutGO, in);
                this.m_Stop.setPoint(this.m_Points[this.m_Points.length - 1]);
            }
        }
    }

    public void setText(String string) {
        this.setUserProperty("Input_Test", string);
    }

    public String getText() {
        return this.getUserProperty("Input_Test");
    }

    public void checkLabel() {
        if (StringUtil.notEmpty(this.getText())) {
            if (this.m_Label == null) {
                this.m_Label = new MovingConnection(this);
                this.m_LabelPoint = new Point(10, 10);
            }
        } else if (this.m_Label != null) {
            this.m_Label = null;
            this.m_LabelPoint = null;
        }
    }

    @Override
    public void setUserProperty(String string, String string2) {
        super.setUserProperty(string, string2);
        this.checkLabel();
    }

    public TextBlock getLabelTextBlock() {
        TextBlock textBlock = new TextBlock();
        textBlock.update(this.getText());
        return textBlock;
    }

    public Point getLabelPoint() {
        Point point = this.m_Label.getPoint();
        return new Point(this.m_LabelPoint.x + point.x, this.m_LabelPoint.y + point.y);
    }

    public void setLabelPoint(Point point) {
        Point point2 = this.m_Label.getPoint();
        Point point3 = point;
        if (Geometry.distanceBetweenPoints(point2, point) > 50.0) {
            RectangleEx rectangleEx = new RectangleEx(point2).grow(50);
            point3 = Geometry.closestPointOnEllipse(rectangleEx, point3);
        }
        this.m_LabelPoint = new Point(point3.x - point2.x, point3.y - point2.y);
    }

    public Boolean isLabel() {
        if (this.m_Label != null) {
            return true;
        }
        return false;
    }
}

